/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties;

import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import lombok.Generated;

public class FileBasedComponent
implements DeclaringComponent {
    private final File source;
    private final int lineNumber;
    private final boolean yaml;
    private final String configType;
    private final String environment;

    public static FileBasedComponent fileSource(File file, int lineNumber, boolean yaml, String configType, String environment) {
        return new FileBasedComponent(file, lineNumber, yaml, configType, environment);
    }

    public String getComponent() {
        return this.source.getParentFile().getName();
    }

    public String toString() {
        return this.relativeSource() + ":" + (this.lineNumber + 1);
    }

    private String relativeSource() {
        String path = StringUtils.unixLikePath((String)this.source.toString());
        int rootIndex = path.indexOf("/components/");
        return rootIndex < 0 ? path : ".." + path.substring(rootIndex);
    }

    @Generated
    public File getSource() {
        return this.source;
    }

    @Generated
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Generated
    public boolean isYaml() {
        return this.yaml;
    }

    @Generated
    public String getConfigType() {
        return this.configType;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileBasedComponent)) {
            return false;
        }
        FileBasedComponent other = (FileBasedComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$source = this.getSource();
        File other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        if (this.isYaml() != other.isYaml()) {
            return false;
        }
        String this$configType = this.getConfigType();
        String other$configType = other.getConfigType();
        if (this$configType == null ? other$configType != null : !this$configType.equals(other$configType)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileBasedComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        result = result * 59 + this.getLineNumber();
        result = result * 59 + (this.isYaml() ? 79 : 97);
        String $configType = this.getConfigType();
        result = result * 59 + ($configType == null ? 43 : $configType.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    @ConstructorProperties(value={"source", "lineNumber", "yaml", "configType", "environment"})
    @Generated
    public FileBasedComponent(File source, int lineNumber, boolean yaml, String configType, String environment) {
        this.source = source;
        this.lineNumber = lineNumber;
        this.yaml = yaml;
        this.configType = configType;
        this.environment = environment;
    }
}

