/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties;

import io.microconfig.core.properties.Properties;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.PropertySerializer;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.Generated;

public class PropertiesImpl
implements Properties {
    private final List<TypedProperties> properties;

    public static Properties flat(List<Properties> properties) {
        return new PropertiesImpl(StreamUtils.flatMapEach(properties, Properties::asTypedProperties));
    }

    public Properties resolveBy(Resolver resolver) {
        return this.withEachComponent(c -> c.resolveBy(resolver));
    }

    public Properties withoutVars() {
        return this.withEachComponent(TypedProperties::withoutVars);
    }

    public Properties without(Predicate<Property> excluded) {
        return this.withEachComponent(c -> c.without(excluded));
    }

    public Properties withPrefix(String prefix) {
        return this.withEachComponent(tp -> tp.withPrefix(prefix));
    }

    public Map<String, Property> getPropertiesAsMap() {
        return this.propertyKeyTo(Function.identity());
    }

    public Map<String, String> getPropertiesAsKeyValue() {
        return this.propertyKeyTo(Property::getValue);
    }

    public Collection<Property> getProperties() {
        return StreamUtils.flatMapEach(this.properties, TypedProperties::getProperties);
    }

    public Optional<Property> getPropertyWithKey(String key) {
        return StreamUtils.findFirstResult(this.properties, p -> p.getPropertyWithKey(key));
    }

    public <T> List<T> save(PropertySerializer<T> serializer) {
        return StreamUtils.forEach(this.properties, p -> p.save(serializer));
    }

    public List<TypedProperties> asTypedProperties() {
        return this.properties;
    }

    public TypedProperties first() {
        return this.properties.get(0);
    }

    public Properties forEachComponent(UnaryOperator<TypedProperties> callback) {
        return this.withEachComponent(callback);
    }

    private Properties withEachComponent(UnaryOperator<TypedProperties> applyFunction) {
        return new PropertiesImpl(StreamUtils.forEach(this.properties.parallelStream(), applyFunction));
    }

    private <T> Map<String, T> propertyKeyTo(Function<Property, T> valueGetter) {
        return (Map)this.properties.stream().map(TypedProperties::getProperties).flatMap(Collection::stream).collect(StreamUtils.toLinkedMap(Property::getKey, valueGetter));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertiesImpl)) {
            return false;
        }
        PropertiesImpl other = (PropertiesImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<Property> this$properties = this.getProperties();
        Collection<Property> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertiesImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<Property> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @ConstructorProperties(value={"properties"})
    @Generated
    public PropertiesImpl(List<TypedProperties> properties) {
        this.properties = properties;
    }
}

