/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties;

import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.ResolveException;
import io.microconfig.core.properties.Resolver;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class PropertyImpl
implements Property {
    private static final String TEMP_VALUE = "#var ";
    private final String key;
    private final String value;
    private final boolean var;
    private final ConfigFormat configFormat;
    private final DeclaringComponent declaringComponent;

    public static Property parse(String keyValue, ConfigFormat configFormat, DeclaringComponent source) {
        boolean temp = PropertyImpl.isTempProperty(keyValue);
        int separatorIndex = PropertyImpl.findSeparatorIndexIn(keyValue);
        if (separatorIndex < 0) {
            throw new IllegalArgumentException("Incorrect delimiter in '" + keyValue + "' in '" + source + "'\nProperty must contain ':' or '=' as delimiter.");
        }
        String key = keyValue.substring(temp ? TEMP_VALUE.length() : 0, separatorIndex).trim();
        String value = keyValue.substring(separatorIndex + 1).trim();
        return new PropertyImpl(key, value, temp, configFormat, source);
    }

    public static Property property(String key, String value, ConfigFormat configFormat, DeclaringComponent source) {
        return new PropertyImpl(key, value, false, configFormat, source);
    }

    public static int findSeparatorIndexIn(String keyValue) {
        return StringUtils.findFirstIndexIn((String)keyValue, (String)":=");
    }

    public static boolean isComment(String line) {
        return line.startsWith("#");
    }

    public static boolean isTempProperty(String line) {
        return line.startsWith(TEMP_VALUE);
    }

    public Property resolveBy(Resolver resolver, DeclaringComponent root) {
        try {
            String resolved = resolver.resolve(this.value, this.declaringComponent, root);
            return this.withValue(resolved);
        }
        catch (ResolveException e) {
            e.setProperty(this);
            throw e;
        }
    }

    public String toString() {
        return (this.var ? "#" : "") + this.key + "=" + this.value;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean isVar() {
        return this.var;
    }

    @Generated
    public ConfigFormat getConfigFormat() {
        return this.configFormat;
    }

    @Generated
    public DeclaringComponent getDeclaringComponent() {
        return this.declaringComponent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        if (this.isVar() != other.isVar()) {
            return false;
        }
        ConfigFormat this$configFormat = this.getConfigFormat();
        ConfigFormat other$configFormat = other.getConfigFormat();
        if (this$configFormat == null ? other$configFormat != null : !this$configFormat.equals(other$configFormat)) {
            return false;
        }
        DeclaringComponent this$declaringComponent = this.getDeclaringComponent();
        DeclaringComponent other$declaringComponent = other.getDeclaringComponent();
        return !(this$declaringComponent == null ? other$declaringComponent != null : !this$declaringComponent.equals(other$declaringComponent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertyImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isVar() ? 79 : 97);
        ConfigFormat $configFormat = this.getConfigFormat();
        result = result * 59 + ($configFormat == null ? 43 : $configFormat.hashCode());
        DeclaringComponent $declaringComponent = this.getDeclaringComponent();
        result = result * 59 + ($declaringComponent == null ? 43 : $declaringComponent.hashCode());
        return result;
    }

    @ConstructorProperties(value={"key", "value", "var", "configFormat", "declaringComponent"})
    @Generated
    private PropertyImpl(String key, String value, boolean var, ConfigFormat configFormat, DeclaringComponent declaringComponent) {
        this.key = key;
        this.value = value;
        this.var = var;
        this.configFormat = configFormat;
        this.declaringComponent = declaringComponent;
    }

    @Generated
    private PropertyImpl withValue(String value) {
        return this.value == value ? this : new PropertyImpl(this.key, value, this.var, this.configFormat, this.declaringComponent);
    }
}

