/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties;

import io.microconfig.core.configtypes.ConfigType;
import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.DeclaringComponentImpl;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.PropertyImpl;
import io.microconfig.core.properties.PropertySerializer;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.core.properties.io.yaml.YamlTreeImpl;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import lombok.Generated;

public class TypedPropertiesImpl
implements TypedProperties {
    private final ConfigType configType;
    private final String component;
    private final String environment;
    private final Map<String, Property> propertyByKey;

    public DeclaringComponent getDeclaringComponent() {
        return new DeclaringComponentImpl(this.configType.getName(), this.component, this.environment);
    }

    public TypedProperties resolveBy(Resolver resolver) {
        return this.withPropertyByKey((Map)StreamUtils.forEach(this.propertyByKey.values(), this.resolveUsing(resolver), this.toPropertyMap()));
    }

    public TypedProperties withoutVars() {
        return this.without(Property::isVar);
    }

    public TypedProperties without(Predicate<Property> excluded) {
        return this.withProperties(excluded.negate());
    }

    public TypedProperties withPrefix(String prefix) {
        return this.withProperties(p -> p.getKey().startsWith(prefix));
    }

    public Map<String, Property> getPropertiesAsMap() {
        return this.propertyByKey;
    }

    public Map<String, String> getPropertiesAsKeyValue() {
        return (Map)this.propertyByKey.values().stream().collect(StreamUtils.toLinkedMap(Property::getKey, Property::getValue));
    }

    public Collection<Property> getProperties() {
        return this.propertyByKey.values();
    }

    public Optional<Property> getPropertyWithKey(String key) {
        Property property = this.propertyByKey.get(key);
        return property != null ? Optional.of(property) : this.tryFindByPrefix(key);
    }

    public <T> T save(PropertySerializer<T> serializer) {
        return (T)serializer.serialize(this.propertyByKey.values(), this.configType, this.component, this.environment);
    }

    private TypedProperties withProperties(Predicate<Property> filter) {
        return this.withPropertyByKey((Map)StreamUtils.filter(this.propertyByKey.values(), filter, this.toPropertyMap()));
    }

    public String toString() {
        return this.getDeclaringComponent().toString();
    }

    private UnaryOperator<Property> resolveUsing(Resolver resolver) {
        DeclaringComponent root = this.getDeclaringComponent();
        return property -> property.resolveBy(resolver, root);
    }

    private Collector<Property, ?, Map<String, Property>> toPropertyMap() {
        return StreamUtils.toLinkedMap(Property::getKey, Function.identity());
    }

    private Optional<Property> tryFindByPrefix(String originalKey) {
        if (!originalKey.endsWith(".*")) {
            return Optional.empty();
        }
        String key = originalKey.substring(0, originalKey.length() - 2);
        Collection withPrefix = this.withPrefix(key).getProperties();
        if (withPrefix.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(PropertyImpl.property(key, this.toYaml(withPrefix, key), ConfigFormat.YAML, this.getDeclaringComponent()));
    }

    private String toYaml(Collection<Property> withPrefix, String key) {
        Map yaml = (Map)withPrefix.stream().collect(StreamUtils.toLinkedMap(property -> property.getKey().substring(key.length() + 1), Property::getValue));
        return new YamlTreeImpl(false).toYaml(yaml);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypedPropertiesImpl)) {
            return false;
        }
        TypedPropertiesImpl other = (TypedPropertiesImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConfigType this$configType = this.getConfigType();
        ConfigType other$configType = other.getConfigType();
        if (this$configType == null ? other$configType != null : !this$configType.equals(other$configType)) {
            return false;
        }
        String this$component = this.component;
        String other$component = other.component;
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        String this$environment = this.environment;
        String other$environment = other.environment;
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        Map<String, Property> this$propertyByKey = this.propertyByKey;
        Map<String, Property> other$propertyByKey = other.propertyByKey;
        return !(this$propertyByKey == null ? other$propertyByKey != null : !((Object)this$propertyByKey).equals(other$propertyByKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TypedPropertiesImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigType $configType = this.getConfigType();
        result = result * 59 + ($configType == null ? 43 : $configType.hashCode());
        String $component = this.component;
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        String $environment = this.environment;
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        Map<String, Property> $propertyByKey = this.propertyByKey;
        result = result * 59 + ($propertyByKey == null ? 43 : ((Object)$propertyByKey).hashCode());
        return result;
    }

    @ConstructorProperties(value={"configType", "component", "environment", "propertyByKey"})
    @Generated
    public TypedPropertiesImpl(ConfigType configType, String component, String environment, Map<String, Property> propertyByKey) {
        this.configType = configType;
        this.component = component;
        this.environment = environment;
        this.propertyByKey = propertyByKey;
    }

    @Generated
    public ConfigType getConfigType() {
        return this.configType;
    }

    @Generated
    private TypedPropertiesImpl withPropertyByKey(Map<String, Property> propertyByKey) {
        return this.propertyByKey == propertyByKey ? this : new TypedPropertiesImpl(this.configType, this.component, this.environment, propertyByKey);
    }
}

