/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.io;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.PropertyImpl;
import io.microconfig.core.properties.io.ConfigReader;
import io.microconfig.io.FsReader;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;

public abstract class AbstractConfigReader
implements ConfigReader {
    protected final File file;
    protected final List<String> lines;

    protected AbstractConfigReader(File file, FsReader fsReader) {
        this(file, fsReader.readLines(file));
    }

    @Override
    public Map<String, String> propertiesAsMap() {
        return (Map)this.properties("", "").stream().collect(StreamUtils.toSortedMap(Property::getKey, Property::getValue));
    }

    @Override
    public Map<Integer, String> commentsByLineNumber() {
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i).trim();
            if (!PropertyImpl.isComment(line)) continue;
            result.put(i, line);
        }
        return result;
    }

    @ConstructorProperties(value={"file", "lines"})
    @Generated
    public AbstractConfigReader(File file, List<String> lines) {
        this.file = file;
        this.lines = lines;
    }
}

