/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.io.properties;

import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.FileBasedComponent;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.PropertyImpl;
import io.microconfig.core.properties.io.AbstractConfigReader;
import io.microconfig.io.FsReader;
import io.microconfig.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class PropertiesReader
extends AbstractConfigReader {
    PropertiesReader(File file, FsReader fileFsReader) {
        super(file, fileFsReader);
    }

    @Override
    public List<Property> properties(String configType, String environment) {
        ArrayList<Property> result = new ArrayList<Property>();
        StringBuilder currentLine = new StringBuilder();
        for (int lineNumber = 0; lineNumber < this.lines.size(); ++lineNumber) {
            String line = (String)this.lines.get(lineNumber);
            String trimmed = line.trim();
            if (trimmed.isEmpty() || PropertyImpl.isComment(trimmed)) continue;
            currentLine.append(trimmed);
            if (this.isMultilineValue(trimmed)) {
                currentLine.append(FileUtils.LINES_SEPARATOR);
                continue;
            }
            Property property = PropertyImpl.parse(currentLine.toString(), ConfigFormat.PROPERTIES, FileBasedComponent.fileSource(this.file, lineNumber, false, configType, environment));
            result.add(property);
            currentLine.setLength(0);
        }
        return result;
    }

    private boolean isMultilineValue(String line) {
        return line.endsWith("\\");
    }
}

