/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.io.yaml;

import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.FileBasedComponent;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.PropertyImpl;
import io.microconfig.core.properties.io.AbstractConfigReader;
import io.microconfig.io.FsReader;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

class YamlReader
extends AbstractConfigReader {
    YamlReader(File file, FsReader fileFsReader) {
        super(file, fileFsReader);
    }

    @Override
    public List<Property> properties(String configType, String environment) {
        ArrayList<Property> result = new ArrayList<Property>();
        ArrayDeque<KeyOffset> currentProperty = new ArrayDeque<KeyOffset>();
        for (int lineNumber = 0; lineNumber < this.lines.size(); ++lineNumber) {
            String line = (String)this.lines.get(lineNumber);
            if (this.skip(line)) continue;
            int currentOffset = this.offsetIndex(line);
            if (this.isMultilineValue(line, currentOffset)) {
                lineNumber = this.addMultilineValue(result, currentProperty, currentOffset, lineNumber, configType, environment);
                continue;
            }
            this.parseSimpleProperty(result, currentProperty, currentOffset, lineNumber, configType, environment);
        }
        return result;
    }

    private boolean isMultilineValue(String line, int currentOffset) {
        char c = line.charAt(currentOffset);
        return Arrays.asList(Character.valueOf('-'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\\'), Character.valueOf('{')).contains(Character.valueOf(c)) || c == '$' && line.length() > currentOffset + 1 && line.charAt(currentOffset + 1) == '{';
    }

    private int addMultilineValue(List<Property> result, Deque<KeyOffset> currentProperty, int currentOffset, int originalLineNumber, String configType, String env) {
        StringBuilder value = new StringBuilder();
        int index = originalLineNumber;
        while (true) {
            String line;
            if (!(line = (String)this.lines.get(index)).isEmpty()) {
                value.append(line.substring(currentOffset));
            }
            if (index + 1 >= this.lines.size() || this.multilineValueEnd((String)this.lines.get(index + 1), currentOffset)) break;
            value.append(FileUtils.LINES_SEPARATOR);
            ++index;
        }
        this.addValue(result, currentProperty, currentOffset, originalLineNumber, null, value.toString(), configType, env);
        return index;
    }

    private boolean multilineValueEnd(String nextLine, int currentOffset) {
        if (this.skip(nextLine) && !PropertyImpl.isComment(nextLine)) {
            return false;
        }
        int nextOffset = this.offsetIndex(nextLine);
        if (currentOffset > nextOffset) {
            return true;
        }
        return currentOffset == nextOffset && !this.isMultilineValue(nextLine, nextOffset);
    }

    private void parseSimpleProperty(List<Property> result, Deque<KeyOffset> currentProperty, int currentOffset, int index, String configType, String env) {
        String line = (String)this.lines.get(index);
        int separatorIndex = line.indexOf(58, currentOffset);
        if (separatorIndex < 0) {
            throw new IllegalArgumentException("Incorrect delimiter in '" + line + "' in '" + new FileBasedComponent(this.file, index, true, configType, env) + "'\nYaml property must contain ':' as delimiter.");
        }
        this.removePropertiesWithBiggerOffset(currentProperty, currentOffset);
        String key = line.substring(currentOffset, separatorIndex).trim();
        if (this.valueEmpty(line, separatorIndex)) {
            if (this.itsLastProperty(index, currentOffset)) {
                this.addValue(result, currentProperty, currentOffset, index - 1, key, "", configType, env);
                return;
            }
            currentProperty.add(new KeyOffset(key, currentOffset, index));
            return;
        }
        String value = line.substring(separatorIndex + 1).trim();
        this.addValue(result, currentProperty, currentOffset, index, key, value, configType, env);
    }

    private boolean valueEmpty(String line, int separatorIndex) {
        return StringUtils.isBlank((String)line.substring(separatorIndex + 1));
    }

    private void removePropertiesWithBiggerOffset(Deque<KeyOffset> currentProperty, int currentOffset) {
        while (!currentProperty.isEmpty() && currentProperty.peekLast().offset >= currentOffset) {
            currentProperty.pollLast();
        }
    }

    private boolean skip(String line) {
        String trim = line.trim();
        return trim.isEmpty() || PropertyImpl.isComment(trim);
    }

    private int offsetIndex(String line) {
        return IntStream.range(0, line.length()).filter(i -> !Character.isWhitespace(line.charAt(i))).findFirst().orElseThrow(() -> new IllegalStateException("assertion error: line is empty"));
    }

    private boolean itsLastProperty(int i, int currentOffset) {
        ++i;
        while (i < this.lines.size()) {
            String line;
            if (this.skip(line = (String)this.lines.get(i++))) continue;
            int offsetIndex = this.offsetIndex(line);
            if (currentOffset > offsetIndex) {
                return true;
            }
            if (currentOffset == offsetIndex) {
                return !this.isMultilineValue(line, offsetIndex);
            }
            return false;
        }
        return true;
    }

    private void addValue(List<Property> result, Deque<KeyOffset> currentProperty, int currentOffset, int line, String lastKey, String value, String configType, String env) {
        if (lastKey != null) {
            currentProperty.add(new KeyOffset(lastKey, currentOffset, line));
        }
        int lineNumber = currentProperty.peekLast().lineNumber;
        String key = this.toProperty(currentProperty);
        currentProperty.pollLast();
        result.add(PropertyImpl.property(key, value, ConfigFormat.YAML, FileBasedComponent.fileSource(this.file, lineNumber, true, configType, env)));
    }

    private String toProperty(Deque<KeyOffset> currentProperty) {
        return currentProperty.stream().map(k -> ((KeyOffset)k).key).collect(Collectors.joining("."));
    }

    private static class KeyOffset {
        private final String key;
        private final int offset;
        private final int lineNumber;

        public String toString() {
            return this.key;
        }

        @ConstructorProperties(value={"key", "offset", "lineNumber"})
        @Generated
        public KeyOffset(String key, int offset, int lineNumber) {
            this.key = key;
            this.offset = offset;
            this.lineNumber = lineNumber;
        }
    }
}

