/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.io.yaml;

import io.microconfig.core.properties.io.yaml.YamlTree;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class YamlTreeImpl
implements YamlTree {
    private static final int OFFSET = 2;
    private final boolean addEmptyLineAfterSections;

    public YamlTreeImpl() {
        this(true);
    }

    public YamlTreeImpl(boolean addEmptyLineAfterSections) {
        this.addEmptyLineAfterSections = addEmptyLineAfterSections;
    }

    @Override
    public String toYaml(Map<String, String> flatProperties) {
        Map<String, Object> tree = new TreeCreator().toTree(flatProperties);
        return new YamlDumper().toYamlFromTree(tree);
    }

    class YamlDumper {
        private final StringBuilder result = new StringBuilder();

        YamlDumper() {
        }

        String toYamlFromTree(Map<String, Object> tree) {
            this.dump(tree, 0, true);
            this.result.setLength(Math.max(0, this.result.length() - FileUtils.LINES_SEPARATOR.length()));
            return this.result.toString();
        }

        private void dump(Map<String, Object> tree, int indent, boolean emptyLine) {
            this.sort(tree).forEach(e -> {
                this.result.append(StringUtils.addOffsets((String)"", (int)indent)).append((String)e.getKey());
                this.dumpValue(e.getValue(), indent + 2);
                if (YamlTreeImpl.this.addEmptyLineAfterSections && emptyLine) {
                    this.result.append(FileUtils.LINES_SEPARATOR);
                }
            });
        }

        private void dumpValue(Object value, int indent) {
            if (value instanceof Map) {
                this.result.append(':').append(FileUtils.LINES_SEPARATOR);
                this.dump((Map)value, indent, false);
                return;
            }
            this.result.append(": ").append(value).append(FileUtils.LINES_SEPARATOR);
        }

        private List<Map.Entry<String, Object>> sort(Map<String, Object> original) {
            return original.entrySet().stream().sorted(Comparator.comparing(this::byDepth).thenComparing(Map.Entry::getKey)).collect(Collectors.toList());
        }

        private int byDepth(Map.Entry<String, Object> entry) {
            return entry.getValue() instanceof Map ? 1 : 0;
        }
    }

    static class TreeCreator {
        TreeCreator() {
        }

        Map<String, Object> toTree(Map<String, String> flatProperties) {
            if (!(flatProperties instanceof TreeMap) || ((TreeMap)flatProperties).comparator() != null) {
                flatProperties = new TreeMap<String, String>(flatProperties);
            }
            TreeMap<String, Object> result = new TreeMap<String, Object>();
            flatProperties.forEach((k, v) -> this.propertyToTree((String)k, (String)v, (Map<String, Object>)result));
            return result;
        }

        private void propertyToTree(String key, String value, Map<String, Object> result) {
            List<String> parts = this.splitKey(key);
            for (int i = 0; i < parts.size() - 1; ++i) {
                String part = parts.get(i);
                Object oldValue = result.get(part);
                if (oldValue == null) {
                    TreeMap<String, TreeMap<String, Object>> newMap = new TreeMap<String, TreeMap<String, Object>>();
                    result.put(part, newMap);
                    result = newMap;
                    continue;
                }
                if (oldValue instanceof Map) {
                    result = (TreeMap<String, TreeMap<String, Object>>)oldValue;
                    continue;
                }
                parts.set(i + 1, part + "." + parts.get(i + 1));
            }
            result.put(parts.get(parts.size() - 1), (TreeMap<String, Object>)((Object)this.offsetForMultilineValue(parts.size(), value)));
        }

        private String offsetForMultilineValue(int parts, String value) {
            if (value.startsWith("-")) {
                return this.withOffsets(parts, value);
            }
            if (value.startsWith("\\")) {
                return this.withOffsets(parts, value.substring(1));
            }
            return value;
        }

        private String withOffsets(int parts, String value) {
            return (FileUtils.LINES_SEPARATOR + value).replace(FileUtils.LINES_SEPARATOR, StringUtils.addOffsets((String)FileUtils.LINES_SEPARATOR, (int)(parts * 2)));
        }

        private List<String> splitKey(String key) {
            if (key.isEmpty()) {
                return Collections.emptyList();
            }
            int insideBrackets = 0;
            boolean insideQuotes = false;
            int last = 0;
            ArrayList<String> results = new ArrayList<String>();
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) == '[') {
                    ++insideBrackets;
                }
                if (key.charAt(i) == ']') {
                    insideBrackets = Math.max(0, insideBrackets - 1);
                }
                if (key.charAt(i) == '\"') {
                    boolean bl = insideQuotes = !insideQuotes;
                }
                if (key.charAt(i) != '.' || insideBrackets != 0 || insideQuotes) continue;
                results.add(key.substring(last, i));
                if (i + 1 >= key.length()) {
                    return results;
                }
                last = i + 1;
            }
            results.add(key.substring(last));
            return results;
        }
    }
}

