/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.io.yaml;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.io.ConfigWriter;
import io.microconfig.core.properties.io.yaml.YamlTree;
import io.microconfig.core.properties.io.yaml.YamlTreeImpl;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;

public class YamlWriter
implements ConfigWriter {
    private final YamlTree yamlTree;
    private final File file;

    public YamlWriter(File file) {
        this(new YamlTreeImpl(), file);
    }

    @Override
    public void write(Map<String, String> properties) {
        this.doWrite(this.serializeMap(properties), new OpenOption[0]);
    }

    @Override
    public void write(Collection<Property> properties) {
        this.doWrite(this.serialize(properties), new OpenOption[0]);
    }

    @Override
    public String serialize(Collection<Property> properties) {
        return this.serializeMap((Map)properties.stream().filter(p -> !p.isVar()).collect(StreamUtils.toSortedMap(Property::getKey, Property::getValue)));
    }

    private String serializeMap(Map<String, String> properties) {
        return this.yamlTree.toYaml(properties);
    }

    private void doWrite(String yaml, OpenOption ... openOptions) {
        FileUtils.write((Path)this.file.toPath(), (String)yaml, (OpenOption[])openOptions);
    }

    @ConstructorProperties(value={"yamlTree", "file"})
    @Generated
    public YamlWriter(YamlTree yamlTree, File file) {
        this.yamlTree = yamlTree;
        this.file = file;
    }
}

