/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.repository;

import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.FileBasedComponent;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.PropertyImpl;
import io.microconfig.core.properties.io.ConfigIo;
import io.microconfig.core.properties.io.ConfigReader;
import io.microconfig.core.properties.repository.Include;
import io.microconfig.core.properties.repository.Includes;
import io.microconfig.core.properties.repository.RawConfig;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ConfigFile {
    private final File file;
    private final String configType;
    private final String environment;

    public RawConfig parseUsing(ConfigIo configIo) {
        ConfigReader reader = configIo.readFrom(this.file);
        Map<Integer, String> commentByLineNumber = reader.commentsByLineNumber();
        List<Include> includes = this.parseIncludes(commentByLineNumber.values());
        if (this.containsIgnoreDirective(commentByLineNumber.values())) {
            return new RawConfig(includes, Collections.emptyMap());
        }
        List<Property> properties = reader.properties(this.configType, this.environment);
        List<Property> tempProperties = this.parseTempProperties(commentByLineNumber);
        return new RawConfig(includes, this.joinToMap(properties, tempProperties));
    }

    private List<Property> parseTempProperties(Map<Integer, String> commentByLineNumber) {
        return commentByLineNumber.entrySet().stream().filter(e -> PropertyImpl.isTempProperty((String)e.getValue())).map(e -> PropertyImpl.parse((String)e.getValue(), ConfigFormat.PROPERTIES, FileBasedComponent.fileSource(this.file, (Integer)e.getKey(), false, this.configType, this.environment))).collect(Collectors.toList());
    }

    private List<Include> parseIncludes(Collection<String> comments) {
        return comments.stream().filter(Includes::isInclude).map(line -> Includes.from(line).withDefaultEnv(this.environment)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean containsIgnoreDirective(Collection<String> comments) {
        return comments.stream().anyMatch(s -> s.startsWith("#@Ignore"));
    }

    private Map<String, Property> joinToMap(List<Property> properties, List<Property> tempProperties) {
        return (Map)Stream.concat(properties.stream(), tempProperties.stream()).collect(StreamUtils.toLinkedMap(Property::getKey, Function.identity()));
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public String getConfigType() {
        return this.configType;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @ConstructorProperties(value={"file", "configType", "environment"})
    @Generated
    public ConfigFile(File file, String configType, String environment) {
        this.file = file;
        this.configType = configType;
        this.environment = environment;
    }
}

