/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.repository;

import io.microconfig.core.configtypes.ConfigType;
import io.microconfig.core.properties.PropertiesRepository;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.io.ConfigIo;
import io.microconfig.core.properties.repository.ComponentGraph;
import io.microconfig.core.properties.repository.ComponentNotFoundException;
import io.microconfig.core.properties.repository.ConfigFile;
import io.microconfig.core.properties.repository.Include;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class FilePropertiesRepository
implements PropertiesRepository {
    private final ComponentGraph componentGraph;
    private final ConfigIo configIo;

    @Override
    public Map<String, Property> getPropertiesOf(String originalComponentName, String environment, ConfigType configType) {
        return new OriginalComponent(originalComponentName, environment, configType, new LinkedHashSet<Include>()).getProperties();
    }

    @ConstructorProperties(value={"componentGraph", "configIo"})
    @Generated
    public FilePropertiesRepository(ComponentGraph componentGraph, ConfigIo configIo) {
        this.componentGraph = componentGraph;
        this.configIo = configIo;
    }

    private class OriginalComponent {
        private final String component;
        private final String environment;
        private final ConfigType configType;
        private final Set<Include> processedIncludes;

        public Map<String, Property> getProperties() {
            return this.readAndParse(this.configFiles());
        }

        private List<ConfigFile> configFiles() {
            return FilePropertiesRepository.this.componentGraph.getConfigFilesOf(this.component, this.environment, this.configType);
        }

        private Map<String, Property> readAndParse(List<ConfigFile> componentConfigFiles) {
            return componentConfigFiles.stream().map(this::parse).reduce(new LinkedHashMap(), (m1, m2) -> {
                m1.putAll(m2);
                return m1;
            });
        }

        private Map<String, Property> parse(ConfigFile configFile) {
            return configFile.parseUsing(FilePropertiesRepository.this.configIo).getBaseAndIncludedProperties(this::includeResolver);
        }

        private Map<String, Property> includeResolver(Include include) {
            try {
                return this.processedIncludes.add(include) ? this.componentFrom(include).getProperties() : Collections.emptyMap();
            }
            catch (ComponentNotFoundException e) {
                throw e.withParentComponent(this.component);
            }
        }

        private OriginalComponent componentFrom(Include include) {
            return this.withComponent(include.getComponent()).withEnvironment(include.getEnvironment());
        }

        @ConstructorProperties(value={"component", "environment", "configType", "processedIncludes"})
        @Generated
        public OriginalComponent(String component, String environment, ConfigType configType, Set<Include> processedIncludes) {
            this.component = component;
            this.environment = environment;
            this.configType = configType;
            this.processedIncludes = processedIncludes;
        }

        @Generated
        public OriginalComponent withComponent(String component) {
            return this.component == component ? this : new OriginalComponent(component, this.environment, this.configType, this.processedIncludes);
        }

        @Generated
        public OriginalComponent withEnvironment(String environment) {
            return this.environment == environment ? this : new OriginalComponent(this.component, environment, this.configType, this.processedIncludes);
        }
    }
}

