/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.repository;

import java.beans.ConstructorProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class Include {
    private static Pattern componentPattern = Pattern.compile("^(?<comp>[\\w-_.]+)(\\[(?<env>.+)])?$");
    private final String component;
    private final String environment;

    static Include parse(String component, String defaultEnv) {
        Matcher componentMatcher = componentPattern.matcher(component);
        if (!componentMatcher.find()) {
            throw new IllegalArgumentException("Can't parse include's component: " + component);
        }
        String comp = componentMatcher.group("comp");
        String env = componentMatcher.group("env");
        return new Include(comp, env == null ? defaultEnv : env);
    }

    public String toString() {
        return "#include " + this.component + "[" + this.environment + "]";
    }

    @Generated
    public String getComponent() {
        return this.component;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Include)) {
            return false;
        }
        Include other = (Include)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$component = this.getComponent();
        String other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Include;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    @ConstructorProperties(value={"component", "environment"})
    @Generated
    public Include(String component, String environment) {
        this.component = component;
        this.environment = environment;
    }
}

