/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.repository;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.repository.Include;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;

public class RawConfig {
    private final List<Include> includes;
    private final Map<String, Property> declaredProperties;

    public Map<String, Property> getBaseAndIncludedProperties(Function<Include, Map<String, Property>> includeResolver) {
        if (this.includes.isEmpty()) {
            return this.declaredProperties;
        }
        LinkedHashMap<String, Property> allProperties = new LinkedHashMap<String, Property>(this.declaredProperties);
        this.getIncludedPropertiesUsing(includeResolver).forEach(allProperties::putIfAbsent);
        return allProperties;
    }

    private Map<String, Property> getIncludedPropertiesUsing(Function<Include, Map<String, Property>> includeResolver) {
        return this.includes.stream().map(includeResolver).reduce(new LinkedHashMap(), (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        });
    }

    @ConstructorProperties(value={"includes", "declaredProperties"})
    @Generated
    public RawConfig(List<Include> includes, Map<String, Property> declaredProperties) {
        this.includes = includes;
        this.declaredProperties = declaredProperties;
    }
}

