/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.resolvers.expression;

import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ExpressionEvaluator {
    private final ExpressionParser parser;
    private final EvaluationContext context;

    public static ExpressionEvaluator withFunctionsFrom(Class<?> ... functionClasses) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        Stream.of(functionClasses).flatMap(c -> Stream.of(c.getMethods())).filter(m -> Modifier.isStatic(m.getModifiers())).forEach(arg_0 -> ExpressionEvaluator.lambda$withFunctionsFrom$2((EvaluationContext)context, arg_0));
        return new ExpressionEvaluator((ExpressionParser)new SpelExpressionParser(), (EvaluationContext)context);
    }

    public String evaluate(String value) {
        return (String)this.parser.parseExpression(value).getValue(this.context, String.class);
    }

    @ConstructorProperties(value={"parser", "context"})
    @Generated
    public ExpressionEvaluator(ExpressionParser parser, EvaluationContext context) {
        this.parser = parser;
        this.context = context;
    }

    private static /* synthetic */ void lambda$withFunctionsFrom$2(EvaluationContext context, Method m) {
        context.setVariable(m.getName(), (Object)m);
    }
}

