/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.resolvers.expression;

import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.ResolveException;
import io.microconfig.core.properties.resolvers.RecursiveResolver;
import io.microconfig.core.properties.resolvers.expression.ExpressionEvaluator;
import io.microconfig.core.properties.resolvers.expression.functions.CustomStringApi;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class ExpressionResolver
implements RecursiveResolver {
    private final Pattern expressionPattern = Pattern.compile("#\\{(?<value>[^{]+?)}");
    private final ExpressionEvaluator evaluator = ExpressionEvaluator.withFunctionsFrom(CustomStringApi.class, System.class);

    @Override
    public Optional<RecursiveResolver.Statement> findStatementIn(CharSequence line) {
        Matcher expressionMatcher = this.expressionPattern.matcher(line);
        return expressionMatcher.find() ? Optional.of(this.toExpression(expressionMatcher)) : Optional.empty();
    }

    private Expression toExpression(Matcher matcher) {
        return new Expression(matcher.group("value"), matcher.start(), matcher.end());
    }

    @Generated
    public ExpressionResolver() {
    }

    private class Expression
    implements RecursiveResolver.Statement {
        private final String value;
        private final int startIndex;
        private final int endIndex;

        @Override
        public String resolveFor(DeclaringComponent component, DeclaringComponent root) {
            try {
                return ExpressionResolver.this.evaluator.evaluate(this.value);
            }
            catch (RuntimeException e) {
                throw new ResolveException(component, root, "Can't evaluate " + this, e);
            }
        }

        public String toString() {
            return "#{" + this.value + "}";
        }

        @ConstructorProperties(value={"value", "startIndex", "endIndex"})
        @Generated
        public Expression(String value, int startIndex, int endIndex) {
            this.value = value;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        @Override
        @Generated
        public int getStartIndex() {
            return this.startIndex;
        }

        @Override
        @Generated
        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

