/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.resolvers.placeholder;

import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.DeclaringComponentImpl;
import io.microconfig.core.properties.PlaceholderResolveStrategy;
import io.microconfig.core.properties.Property;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class Placeholder {
    private static final String SELF_REFERENCE = "this";
    private final String configType;
    private final String component;
    private final String environment;
    private final String key;
    private final String defaultValue;

    public Property resolveUsing(PlaceholderResolveStrategy strategy) {
        return (Property)strategy.resolve(this.component, this.key, this.environment, this.configType).orElseThrow(() -> new IllegalStateException("Can't resolve " + this));
    }

    public DeclaringComponent getReferencedComponent() {
        return new DeclaringComponentImpl(this.configType, this.component, this.environment);
    }

    public boolean isSelfReferenced() {
        return this.component.equals(SELF_REFERENCE);
    }

    public boolean referencedTo(DeclaringComponent c) {
        return this.component.equals(c.getComponent()) && this.environment.equals(c.getEnvironment());
    }

    public Placeholder overrideBy(DeclaringComponent c) {
        return this.withComponent(c.getComponent()).withEnvironment(c.getEnvironment());
    }

    public String toString() {
        return "${" + this.component + "[" + this.environment + "]@" + this.key + (this.defaultValue == null ? "" : ":" + this.defaultValue) + "}";
    }

    @Generated
    public String getConfigType() {
        return this.configType;
    }

    @Generated
    public String getComponent() {
        return this.component;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Placeholder)) {
            return false;
        }
        Placeholder other = (Placeholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$configType = this.getConfigType();
        String other$configType = other.getConfigType();
        if (this$configType == null ? other$configType != null : !this$configType.equals(other$configType)) {
            return false;
        }
        String this$component = this.getComponent();
        String other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Placeholder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $configType = this.getConfigType();
        result = result * 59 + ($configType == null ? 43 : $configType.hashCode());
        String $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @ConstructorProperties(value={"configType", "component", "environment", "key", "defaultValue"})
    @Generated
    Placeholder(String configType, String component, String environment, String key, String defaultValue) {
        this.configType = configType;
        this.component = component;
        this.environment = environment;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Generated
    public Placeholder withComponent(String component) {
        return this.component == component ? this : new Placeholder(this.configType, component, this.environment, this.key, this.defaultValue);
    }

    @Generated
    public Placeholder withEnvironment(String environment) {
        return this.environment == environment ? this : new Placeholder(this.configType, this.component, environment, this.key, this.defaultValue);
    }
}

