/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.serializers;

import com.google.gson.Gson;
import io.microconfig.utils.StreamUtils;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class ConfigResult {
    private final String component;
    private final String configType;
    private final String fileName;
    private final String content;

    public static String toJson(List<ConfigResult> configResults) {
        return new Gson().toJson(ConfigResult.groupsByService(configResults));
    }

    public static List<ServiceConfigs> groupsByService(List<ConfigResult> configResults) {
        return configResults.stream().filter(c -> !StringUtils.isEmpty((String)c.getContent())).collect(Collectors.groupingBy(ConfigResult::getComponent)).entrySet().stream().map(e -> new ServiceConfigs((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"component", "configType", "fileName", "content"})
    @Generated
    public ConfigResult(String component, String configType, String fileName, String content) {
        this.component = component;
        this.configType = configType;
        this.fileName = fileName;
        this.content = content;
    }

    @Generated
    public String getComponent() {
        return this.component;
    }

    @Generated
    public String getConfigType() {
        return this.configType;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigResult)) {
            return false;
        }
        ConfigResult other = (ConfigResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$component = this.getComponent();
        String other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        String this$configType = this.getConfigType();
        String other$configType = other.getConfigType();
        if (this$configType == null ? other$configType != null : !this$configType.equals(other$configType)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        String $configType = this.getConfigType();
        result = result * 59 + ($configType == null ? 43 : $configType.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigResult(component=" + this.getComponent() + ", configType=" + this.getConfigType() + ", fileName=" + this.getFileName() + ", content=" + this.getContent() + ")";
    }

    public static class FileResult {
        private final String configType;
        private final String fileName;
        private final String content;

        FileResult(ConfigResult configResult) {
            this(configResult.getConfigType(), configResult.getFileName(), configResult.getContent());
        }

        @Generated
        public String getConfigType() {
            return this.configType;
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @ConstructorProperties(value={"configType", "fileName", "content"})
        @Generated
        public FileResult(String configType, String fileName, String content) {
            this.configType = configType;
            this.fileName = fileName;
            this.content = content;
        }
    }

    public static class ServiceConfigs {
        private final String service;
        private final List<FileResult> files;

        ServiceConfigs(String service, List<ConfigResult> configResults) {
            this.service = service;
            this.files = StreamUtils.forEach(configResults, FileResult::new);
        }

        @Generated
        public String getService() {
            return this.service;
        }

        @Generated
        public List<FileResult> getFiles() {
            return this.files;
        }
    }
}

