/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.serializers;

import io.microconfig.core.configtypes.ConfigTypeImpl;
import io.microconfig.core.configtypes.StandardConfigType;
import io.microconfig.core.environments.EnvironmentRepository;
import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.PropertySerializer;
import io.microconfig.core.properties.io.selector.ConfigIoFactory;
import io.microconfig.core.properties.serializers.ConfigDiff;
import io.microconfig.core.properties.serializers.ConfigResult;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.Logger;
import java.io.File;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;

public class PropertySerializers {
    public static BiConsumer<File, Collection<Property>> withConfigDiff() {
        ConfigDiff configDiff = new ConfigDiff();
        return configDiff::storeDiffFor;
    }

    public static PropertySerializer<File> toFileIn(File dir) {
        return PropertySerializers.toFileIn(dir, (_1, _2) -> {});
    }

    public static PropertySerializer<ConfigResult> asConfigResult() {
        return (properties, configType, componentName, __) -> {
            String fileName = configType.getResultFileName() + PropertySerializers.extensionByConfigFormat(properties).extension();
            String output = properties.isEmpty() ? "" : ConfigIoFactory.configIo().writeTo(new File(fileName)).serialize(properties);
            return new ConfigResult(componentName, configType.getName(), fileName, output);
        };
    }

    public static PropertySerializer<File> toFileIn(File dir, BiConsumer<File, Collection<Property>> listener) {
        return (properties, configType, componentName, __) -> {
            Function<ConfigFormat, File> getResultFile = cf -> new File(dir, componentName + "/" + configType.getResultFileName() + cf.extension());
            File resultFile = getResultFile.apply(PropertySerializers.extensionByConfigFormat(properties));
            listener.accept(resultFile, properties);
            if (properties.isEmpty()) {
                FileUtils.delete((File)resultFile);
                FileUtils.delete((File)getResultFile.apply(ConfigFormat.PROPERTIES));
            } else {
                ConfigIoFactory.configIo().writeTo(resultFile).write(properties);
                Logger.info((String)("Generated " + componentName + "/" + resultFile.getName()));
            }
            return resultFile;
        };
    }

    public static PropertySerializer<String> asString() {
        return (properties, _2, _3, _4) -> ConfigIoFactory.configIo().writeTo(new File(PropertySerializers.extensionByConfigFormat(properties).extension())).serialize(properties);
    }

    private static ConfigFormat extensionByConfigFormat(Collection<Property> properties) {
        return properties.isEmpty() || properties.stream().anyMatch(p -> p.getConfigFormat() == ConfigFormat.YAML) ? ConfigFormat.YAML : ConfigFormat.PROPERTIES;
    }

    public static PropertySerializer<File> withLegacySupport(PropertySerializer<File> serializer, EnvironmentRepository environmentRepository) {
        return (properties, configType, componentName, environment) -> {
            File envSource;
            if (configType.getName().equals(StandardConfigType.APPLICATION.getName()) && (envSource = environmentRepository.getByName(environment).getSource()) != null && envSource.toString().endsWith(".json")) {
                configType = new ConfigTypeImpl(configType.getName(), configType.getSourceExtensions(), "service");
            }
            return (File)serializer.serialize(properties, configType, componentName, environment);
        };
    }

    @Generated
    private PropertySerializers() {
    }
}

