/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.core.properties.io.yaml.YamlTreeImpl;
import io.microconfig.core.templates.TemplateContentPostProcessor;
import io.microconfig.utils.Logger;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class MustacheTemplateProcessor
implements TemplateContentPostProcessor {
    private static final String MUSTACHE = "mustache";

    public String process(String templateType, File source, String templateContent, TypedProperties properties) {
        if (!this.isMustacheTemplate(source, templateType)) {
            return templateContent;
        }
        Logger.info((String)("Using mustache template for " + properties.getDeclaringComponent().getComponent() + "/" + source.getName()));
        return this.compile(source, templateContent).execute(this.toYaml(properties));
    }

    private boolean isMustacheTemplate(File source, String templateType) {
        return source.getName().endsWith(".mustache") || templateType.equals(MUSTACHE);
    }

    private Template compile(File currentTemplate, String source) {
        return Mustache.compiler().withLoader(this.templateLoader(currentTemplate)).compile(source);
    }

    private Mustache.TemplateLoader templateLoader(File currentTemplate) {
        return fileName -> {
            File newTemplate = new File(fileName);
            File fullPath = newTemplate.isAbsolute() ? newTemplate : new File(currentTemplate.getParent(), fileName);
            return new FileReader(fullPath);
        };
    }

    private Map<String, Object> toYaml(TypedProperties properties) {
        String text = new YamlTreeImpl().toYaml(properties.getPropertiesAsKeyValue());
        return (Map)new Yaml().load(text);
    }
}

