/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates;

import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.core.properties.resolvers.placeholder.PlaceholderBorders;
import io.microconfig.core.templates.TemplateContentPostProcessor;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.IoUtils;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

class Template {
    private final String templateName;
    private final File source;
    private final Pattern pattern;
    private final String content;

    Template(String templateName, File source, Pattern pattern) {
        if (!source.exists() || !source.isFile()) {
            throw new IllegalStateException("Missing template file: " + source);
        }
        this.templateName = templateName;
        this.source = source;
        this.pattern = pattern;
        this.content = IoUtils.readFully((File)source);
    }

    public Template resolveBy(Resolver resolver, DeclaringComponent currentComponent) {
        String replaced = this.content.replace("${this@templateName}", this.templateNameWithoutBrackets());
        Matcher m = this.pattern.matcher(replaced);
        if (!m.find()) {
            return this.withContent(replaced);
        }
        StringBuffer result = new StringBuffer();
        do {
            this.doResolve(m, result, resolver, currentComponent);
        } while (m.find());
        m.appendTail(result);
        String content = result.toString();
        return this.withContent(content);
    }

    String templateNameWithoutBrackets() {
        return this.templateName.replaceFirst("\\[.+]$", "");
    }

    public Template postProcessContent(TemplateContentPostProcessor postProcessor, String templateType, TypedProperties properties) {
        return this.withContent(postProcessor.process(templateType, this.source, this.content, properties));
    }

    public void copyTo(File destinationFile) {
        FileUtils.write((File)destinationFile, (String)this.content);
        FileUtils.copyPermissions((Path)this.source.toPath(), (Path)destinationFile.toPath());
    }

    private void doResolve(Matcher m, StringBuffer result, Resolver resolver, DeclaringComponent currentComponent) {
        if (m.group("escaped") != null) {
            m.appendReplacement(result, Matcher.quoteReplacement(m.group("placeholder")));
            return;
        }
        String resolved = this.resolve(m.group(), currentComponent, resolver);
        if (resolved == null) {
            return;
        }
        String finalValue = this.addOffsetForMultiLineValue(resolved, m);
        m.appendReplacement(result, Matcher.quoteReplacement(finalValue));
    }

    public static boolean isValidPlaceholder(String value) {
        return PlaceholderBorders.findPlaceholderIn(value).isPresent();
    }

    private String resolve(String placeholder, DeclaringComponent currentComponent, Resolver resolver) {
        if (Template.isValidPlaceholder(placeholder)) {
            return this.doResolve(placeholder, resolver, currentComponent);
        }
        String newFormat = "${this@" + placeholder.substring("${".length());
        if (!Template.isValidPlaceholder(newFormat)) {
            return null;
        }
        try {
            return this.doResolve(newFormat, resolver, currentComponent);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String doResolve(String placeholder, Resolver resolver, DeclaringComponent currentComponent) {
        return resolver.resolve(placeholder, currentComponent, currentComponent);
    }

    private String addOffsetForMultiLineValue(String value, Matcher m) {
        int lineBeginIndex = this.content.lastIndexOf(10, m.start());
        int placeholderOffset = m.start() - lineBeginIndex - 1;
        return value.replace("\n", StringUtils.addOffsets((String)"\n", (int)placeholderOffset));
    }

    @ConstructorProperties(value={"templateName", "source", "pattern", "content"})
    @Generated
    public Template(String templateName, File source, Pattern pattern, String content) {
        this.templateName = templateName;
        this.source = source;
        this.pattern = pattern;
        this.content = content;
    }

    @Generated
    public Template withContent(String content) {
        return this.content == content ? this : new Template(this.templateName, this.source, this.pattern, content);
    }

    @Generated
    public String getContent() {
        return this.content;
    }
}

