/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates;

import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.core.properties.templates.MustacheTemplateProcessor;
import io.microconfig.core.properties.templates.Template;
import io.microconfig.core.properties.templates.TemplatePattern;
import io.microconfig.core.templates.TemplateContentPostProcessor;
import io.microconfig.utils.Logger;
import java.beans.ConstructorProperties;
import java.io.File;
import lombok.Generated;

public class TemplateDefinition {
    private final String templateType;
    private final String templateName;
    private final TemplatePattern templatePattern;
    private final TemplateContentPostProcessor templateContentPostProcessor;
    private File fromFile;
    private File toFile;

    public TemplateDefinition(String templateType, String templateName, TemplatePattern pattern) {
        this(templateType, templateName, pattern, new MustacheTemplateProcessor());
    }

    public void resolveAndCopy(Resolver resolver, TypedProperties properties) {
        DeclaringComponent currentComponent = properties.getDeclaringComponent();
        this.toTemplate().resolveBy(resolver, currentComponent).postProcessContent(this.templateContentPostProcessor, this.templateType, properties).copyTo(this.destinationFileFor(currentComponent, resolver));
        Logger.info((String)("Copied '" + currentComponent.getComponent() + "' template ../" + this.fromFile.getParentFile().getName() + "/" + this.fromFile.getName() + " -> " + this.toFile));
    }

    private Template toTemplate() {
        if (!this.isCorrect()) {
            throw new IllegalStateException("Incomplete template def: " + this);
        }
        return new Template(this.templateName, this.getTemplateFile(), this.templatePattern.getPlaceholderPattern());
    }

    private boolean isCorrect() {
        return this.fromFile != null && this.toFile != null;
    }

    private File getTemplateFile() {
        if (!this.fromFile.isAbsolute()) {
            throw new IllegalArgumentException("Using relative path for template '" + this.fromFile + "'. Template path must be absolute. Consider using '${this@configRoot}\\..' or '${component_name@configDir}\\..' to build absolute path");
        }
        return this.fromFile;
    }

    private File destinationFileFor(DeclaringComponent currentComponent, Resolver resolver) {
        return this.toFile.isAbsolute() ? this.toFile : new File(this.destinationDir(currentComponent, resolver), this.toFile.getPath());
    }

    private String destinationDir(DeclaringComponent currentComponent, Resolver resolver) {
        return resolver.resolve("${this@resultDir}", currentComponent, currentComponent);
    }

    public void setFromFile(String fromFile) {
        this.fromFile = new File(fromFile);
        if (this.toFile == null) {
            this.setToFile(this.fromFile.getName());
        }
    }

    public void setToFile(String toFile) {
        this.toFile = new File(toFile.replace("${templateName}", this.templateName));
    }

    public String toString() {
        return "templateName: '" + this.templateName + "', file: '" + this.fromFile + "' -> '" + this.toFile + "'";
    }

    @ConstructorProperties(value={"templateType", "templateName", "templatePattern", "templateContentPostProcessor"})
    @Generated
    public TemplateDefinition(String templateType, String templateName, TemplatePattern templatePattern, TemplateContentPostProcessor templateContentPostProcessor) {
        this.templateType = templateType;
        this.templateName = templateName;
        this.templatePattern = templatePattern;
        this.templateContentPostProcessor = templateContentPostProcessor;
    }

    @Generated
    public String getTemplateName() {
        return this.templateName;
    }

    @Generated
    public File getFromFile() {
        return this.fromFile;
    }

    @Generated
    public File getToFile() {
        return this.toFile;
    }
}

