/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;

public class TemplatePattern {
    public static final Pattern DEFAULT_PATTERN = Pattern.compile("(?<escaped>\\\\)?(?<placeholder>\\$\\{(?<name>.+?)(?::(?<defuvalue>.*?))??})");
    private final List<String> templatePrefixes;
    private final Pattern placeholderPattern;

    public static TemplatePattern defaultPattern() {
        return TemplatePattern.builder().templatePrefixes(Arrays.asList("microconfig.template.", "mc.template.", "mc.mustache.", "microconfig.mustache.")).placeholderPattern(DEFAULT_PATTERN).build();
    }

    public boolean startsWithTemplatePrefix(String key) {
        return this.templatePrefixes.stream().anyMatch(key::startsWith);
    }

    public String extractTemplateType(String str) {
        int templateTypeStartIndex = str.indexOf(46) + 1;
        int secondDot = str.indexOf(46, templateTypeStartIndex);
        return str.substring(templateTypeStartIndex, secondDot);
    }

    public String extractTemplateName(String str) {
        return this.templatePrefixes.stream().filter(str::startsWith).map(prefix -> str.replaceFirst((String)prefix, "")).map(key -> key.split("\\.")[0]).findFirst().orElseThrow(() -> new IllegalArgumentException("Incorrect template " + str));
    }

    @ConstructorProperties(value={"templatePrefixes", "placeholderPattern"})
    @Generated
    TemplatePattern(List<String> templatePrefixes, Pattern placeholderPattern) {
        this.templatePrefixes = templatePrefixes;
        this.placeholderPattern = placeholderPattern;
    }

    @Generated
    public static TemplatePatternBuilder builder() {
        return new TemplatePatternBuilder();
    }

    @Generated
    public TemplatePattern withTemplatePrefixes(List<String> templatePrefixes) {
        return this.templatePrefixes == templatePrefixes ? this : new TemplatePattern(templatePrefixes, this.placeholderPattern);
    }

    @Generated
    public TemplatePattern withPlaceholderPattern(Pattern placeholderPattern) {
        return this.placeholderPattern == placeholderPattern ? this : new TemplatePattern(this.templatePrefixes, placeholderPattern);
    }

    @Generated
    public List<String> getTemplatePrefixes() {
        return this.templatePrefixes;
    }

    @Generated
    public Pattern getPlaceholderPattern() {
        return this.placeholderPattern;
    }

    @Generated
    public static class TemplatePatternBuilder {
        @Generated
        private List<String> templatePrefixes;
        @Generated
        private Pattern placeholderPattern;

        @Generated
        TemplatePatternBuilder() {
        }

        @Generated
        public TemplatePatternBuilder templatePrefixes(List<String> templatePrefixes) {
            this.templatePrefixes = templatePrefixes;
            return this;
        }

        @Generated
        public TemplatePatternBuilder placeholderPattern(Pattern placeholderPattern) {
            this.placeholderPattern = placeholderPattern;
            return this;
        }

        @Generated
        public TemplatePattern build() {
            return new TemplatePattern(this.templatePrefixes, this.placeholderPattern);
        }

        @Generated
        public String toString() {
            return "TemplatePattern.TemplatePatternBuilder(templatePrefixes=" + this.templatePrefixes + ", placeholderPattern=" + this.placeholderPattern + ")";
        }
    }
}

