/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.core.properties.templates.TemplateDefinition;
import io.microconfig.core.properties.templates.TemplateDefinitionParser;
import io.microconfig.core.properties.templates.TemplatePattern;
import io.microconfig.core.properties.templates.definition.parser.ArrowNotationParser;
import io.microconfig.core.properties.templates.definition.parser.FromToNotationParser;
import io.microconfig.core.properties.templates.definition.parser.SquareBracketsNotationParser;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;

public class TemplatesService {
    private final TemplatePattern templatePattern;
    private final List<TemplateDefinitionParser> templateDefinitionParsers;

    public TemplatesService() {
        this.templatePattern = TemplatePattern.defaultPattern();
        this.templateDefinitionParsers = Arrays.asList(new FromToNotationParser(this.templatePattern), new ArrowNotationParser(this.templatePattern), new SquareBracketsNotationParser(this.templatePattern));
    }

    public static UnaryOperator<TypedProperties> resolveTemplatesBy(Resolver resolver) {
        TemplatesService templatesService = new TemplatesService();
        return tp -> {
            templatesService.resolveTemplate((TypedProperties)tp, resolver);
            return tp.without(p -> templatesService.templatePattern.startsWithTemplatePrefix(p.getKey()));
        };
    }

    public void resolveTemplate(TypedProperties properties, Resolver resolver) {
        Collection<TemplateDefinition> templateDefinitions = this.findTemplateDefinitionsFrom(properties.getProperties());
        templateDefinitions.forEach(def -> {
            try {
                def.resolveAndCopy(resolver, properties);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Template error: " + def + "\nComponent: " + properties.getDeclaringComponent() + "\n" + StringUtils.getExceptionMessage((Throwable)e), e);
            }
        });
    }

    private Collection<TemplateDefinition> findTemplateDefinitionsFrom(Collection<Property> componentProperties) {
        List templateProperties = componentProperties.stream().filter(p -> this.templatePattern.startsWithTemplatePrefix(p.getKey())).collect(Collectors.toList());
        return this.templateDefinitionParsers.stream().map(parser -> parser.parse(templateProperties)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"templatePattern", "templateDefinitionParsers"})
    @Generated
    public TemplatesService(TemplatePattern templatePattern, List<TemplateDefinitionParser> templateDefinitionParsers) {
        this.templatePattern = templatePattern;
        this.templateDefinitionParsers = templateDefinitionParsers;
    }
}

