/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core;

import io.microconfig.core.configtypes.CompositeConfigTypeRepository;
import io.microconfig.core.configtypes.ConfigTypeRepository;
import io.microconfig.core.configtypes.CustomConfigTypeRepository;
import io.microconfig.core.configtypes.StandardConfigTypeRepository;
import io.microconfig.core.environments.ComponentFactory;
import io.microconfig.core.environments.ComponentFactoryImpl;
import io.microconfig.core.environments.Environment;
import io.microconfig.core.environments.EnvironmentRepository;
import io.microconfig.core.environments.repository.FileEnvironmentRepository;
import io.microconfig.core.properties.PlaceholderResolveStrategy;
import io.microconfig.core.properties.PropertiesFactory;
import io.microconfig.core.properties.PropertiesFactoryImpl;
import io.microconfig.core.properties.PropertiesRepository;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.io.selector.ConfigIoFactory;
import io.microconfig.core.properties.repository.ComponentGraph;
import io.microconfig.core.properties.repository.ComponentGraphImpl;
import io.microconfig.core.properties.repository.CompositePropertiesRepository;
import io.microconfig.core.properties.repository.FilePropertiesRepository;
import io.microconfig.core.properties.resolvers.ChainedResolver;
import io.microconfig.core.properties.resolvers.RecursiveResolver;
import io.microconfig.core.properties.resolvers.expression.ExpressionResolver;
import io.microconfig.core.properties.resolvers.placeholder.PlaceholderResolver;
import io.microconfig.core.properties.resolvers.placeholder.strategies.component.ComponentProperty;
import io.microconfig.core.properties.resolvers.placeholder.strategies.component.ComponentResolveStrategy;
import io.microconfig.core.properties.resolvers.placeholder.strategies.component.properties.ComponentProperties;
import io.microconfig.core.properties.resolvers.placeholder.strategies.composite.CompositeResolveStrategy;
import io.microconfig.core.properties.resolvers.placeholder.strategies.environment.EnvProperty;
import io.microconfig.core.properties.resolvers.placeholder.strategies.environment.EnvironmentResolveStrategy;
import io.microconfig.core.properties.resolvers.placeholder.strategies.environment.properties.EnvironmentProperties;
import io.microconfig.core.properties.resolvers.placeholder.strategies.standard.StandardResolveStrategy;
import io.microconfig.core.properties.resolvers.placeholder.strategies.system.SystemResolveStrategy;
import io.microconfig.io.DumpedFsReader;
import io.microconfig.io.FsReader;
import io.microconfig.utils.CacheProxy;
import io.microconfig.utils.CollectionUtils;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.Logger;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public class Microconfig {
    private final File rootDir;
    private final File destinationDir;
    private final FsReader fsReader;
    private final List<PlaceholderResolveStrategy> additionalPlaceholderResolvers;
    private final List<PropertiesRepository> additionalPropertiesRepositories;
    private final Dependencies dependencies = new Dependencies();

    public static Microconfig searchConfigsIn(File rootDir) {
        File canonical = FileUtils.canonical((File)rootDir);
        if (!canonical.exists()) {
            throw new IllegalArgumentException("Root directory doesn't exist: " + rootDir);
        }
        return new Microconfig(canonical, new File(rootDir, "build"), (FsReader)new DumpedFsReader(), Collections.emptyList(), Collections.emptyList());
    }

    public Environment inEnvironment(String name) {
        return this.environments().getByName(name);
    }

    public EnvironmentRepository environments() {
        return this.dependencies.environments();
    }

    public Resolver resolver() {
        return this.dependencies.resolver();
    }

    public void logger(boolean enabled) {
        Logger.enableLogger((boolean)enabled);
    }

    @Generated
    public File rootDir() {
        return this.rootDir;
    }

    @Generated
    public File destinationDir() {
        return this.destinationDir;
    }

    @Generated
    public FsReader fsReader() {
        return this.fsReader;
    }

    @Generated
    public List<PlaceholderResolveStrategy> additionalPlaceholderResolvers() {
        return this.additionalPlaceholderResolvers;
    }

    @Generated
    public List<PropertiesRepository> additionalPropertiesRepositories() {
        return this.additionalPropertiesRepositories;
    }

    @Generated
    public Dependencies dependencies() {
        return this.dependencies;
    }

    @ConstructorProperties(value={"rootDir", "destinationDir", "fsReader", "additionalPlaceholderResolvers", "additionalPropertiesRepositories"})
    @Generated
    private Microconfig(File rootDir, File destinationDir, FsReader fsReader, List<PlaceholderResolveStrategy> additionalPlaceholderResolvers, List<PropertiesRepository> additionalPropertiesRepositories) {
        this.rootDir = rootDir;
        this.destinationDir = destinationDir;
        this.fsReader = fsReader;
        this.additionalPlaceholderResolvers = additionalPlaceholderResolvers;
        this.additionalPropertiesRepositories = additionalPropertiesRepositories;
    }

    @Generated
    public Microconfig withDestinationDir(File destinationDir) {
        return this.destinationDir == destinationDir ? this : new Microconfig(this.rootDir, destinationDir, this.fsReader, this.additionalPlaceholderResolvers, this.additionalPropertiesRepositories);
    }

    @Generated
    public Microconfig withFsReader(FsReader fsReader) {
        return this.fsReader == fsReader ? this : new Microconfig(this.rootDir, this.destinationDir, fsReader, this.additionalPlaceholderResolvers, this.additionalPropertiesRepositories);
    }

    @Generated
    public Microconfig withAdditionalPlaceholderResolvers(List<PlaceholderResolveStrategy> additionalPlaceholderResolvers) {
        return this.additionalPlaceholderResolvers == additionalPlaceholderResolvers ? this : new Microconfig(this.rootDir, this.destinationDir, this.fsReader, additionalPlaceholderResolvers, this.additionalPropertiesRepositories);
    }

    @Generated
    public Microconfig withAdditionalPropertiesRepositories(List<PropertiesRepository> additionalPropertiesRepositories) {
        return this.additionalPropertiesRepositories == additionalPropertiesRepositories ? this : new Microconfig(this.rootDir, this.destinationDir, this.fsReader, this.additionalPlaceholderResolvers, additionalPropertiesRepositories);
    }

    public class Dependencies {
        private final AtomicReference<Object> environments = new AtomicReference();
        private final AtomicReference<Object> componentFactory = new AtomicReference();
        private final AtomicReference<Object> configTypeRepository = new AtomicReference();
        private final AtomicReference<Object> propertiesFactory = new AtomicReference();
        private final AtomicReference<Object> componentGraph = new AtomicReference();
        private final AtomicReference<Object> resolver = new AtomicReference();

        private EnvironmentRepository initEnvironments() {
            return (EnvironmentRepository)CacheProxy.cache((Object)new FileEnvironmentRepository(Microconfig.this.rootDir, Microconfig.this.fsReader, this.componentFactory(), this.propertiesFactory()));
        }

        private ComponentFactory initComponentFactory() {
            return (ComponentFactory)CacheProxy.cache((Object)new ComponentFactoryImpl(this.configTypeRepository(), this.propertiesFactory()));
        }

        private PropertiesFactory initPropertiesFactory() {
            FilePropertiesRepository fileRepository = new FilePropertiesRepository(this.componentGraph(), ConfigIoFactory.newConfigIo(Microconfig.this.fsReader));
            return (PropertiesFactory)CacheProxy.cache((Object)new PropertiesFactoryImpl((PropertiesRepository)CacheProxy.cache((Object)CompositePropertiesRepository.compositeOf(Microconfig.this.additionalPropertiesRepositories, fileRepository))));
        }

        public Resolver initResolver() {
            return (Resolver)CacheProxy.cache((Object)ChainedResolver.chainOf(this.initPlaceholderResolver(), new ExpressionResolver()));
        }

        private RecursiveResolver initPlaceholderResolver() {
            Map<String, ComponentProperty> componentSpecialProperties = new ComponentProperties(this.componentGraph(), this.environments(), Microconfig.this.rootDir, Microconfig.this.destinationDir).get();
            Map<String, EnvProperty> envSpecialProperties = new EnvironmentProperties().get();
            PlaceholderResolveStrategy strategy = (PlaceholderResolveStrategy)CacheProxy.cache((Object)CompositeResolveStrategy.composite(CollectionUtils.join((Collection)Microconfig.this.additionalPlaceholderResolvers, Arrays.asList(SystemResolveStrategy.systemPropertiesResolveStrategy(), SystemResolveStrategy.envVariablesResolveStrategy(), new ComponentResolveStrategy(componentSpecialProperties), new EnvironmentResolveStrategy(this.environments(), envSpecialProperties), new StandardResolveStrategy(this.environments())))));
            return new PlaceholderResolver(strategy, CollectionUtils.joinToSet(componentSpecialProperties.keySet(), envSpecialProperties.keySet()));
        }

        private ConfigTypeRepository initConfigTypeRepository() {
            return (ConfigTypeRepository)CacheProxy.cache((Object)CompositeConfigTypeRepository.composite(CustomConfigTypeRepository.findDescriptorIn(Microconfig.this.rootDir, Microconfig.this.fsReader), new StandardConfigTypeRepository()));
        }

        private ComponentGraph initComponentGraph() {
            return ComponentGraphImpl.traverseFrom(Microconfig.this.rootDir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public EnvironmentRepository environments() {
            Object value = this.environments.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.environments;
                synchronized (atomicReference) {
                    value = this.environments.get();
                    if (value == null) {
                        EnvironmentRepository actualValue = this.initEnvironments();
                        value = actualValue == null ? this.environments : actualValue;
                        this.environments.set(value);
                    }
                }
            }
            return (EnvironmentRepository)(value == this.environments ? null : value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public ComponentFactory componentFactory() {
            Object value = this.componentFactory.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.componentFactory;
                synchronized (atomicReference) {
                    value = this.componentFactory.get();
                    if (value == null) {
                        ComponentFactory actualValue = this.initComponentFactory();
                        value = actualValue == null ? this.componentFactory : actualValue;
                        this.componentFactory.set(value);
                    }
                }
            }
            return (ComponentFactory)(value == this.componentFactory ? null : value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public ConfigTypeRepository configTypeRepository() {
            Object value = this.configTypeRepository.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.configTypeRepository;
                synchronized (atomicReference) {
                    value = this.configTypeRepository.get();
                    if (value == null) {
                        ConfigTypeRepository actualValue = this.initConfigTypeRepository();
                        value = actualValue == null ? this.configTypeRepository : actualValue;
                        this.configTypeRepository.set(value);
                    }
                }
            }
            return (ConfigTypeRepository)(value == this.configTypeRepository ? null : value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public PropertiesFactory propertiesFactory() {
            Object value = this.propertiesFactory.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.propertiesFactory;
                synchronized (atomicReference) {
                    value = this.propertiesFactory.get();
                    if (value == null) {
                        PropertiesFactory actualValue = this.initPropertiesFactory();
                        value = actualValue == null ? this.propertiesFactory : actualValue;
                        this.propertiesFactory.set(value);
                    }
                }
            }
            return (PropertiesFactory)(value == this.propertiesFactory ? null : value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public ComponentGraph componentGraph() {
            Object value = this.componentGraph.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.componentGraph;
                synchronized (atomicReference) {
                    value = this.componentGraph.get();
                    if (value == null) {
                        ComponentGraph actualValue = this.initComponentGraph();
                        value = actualValue == null ? this.componentGraph : actualValue;
                        this.componentGraph.set(value);
                    }
                }
            }
            return (ComponentGraph)(value == this.componentGraph ? null : value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public Resolver resolver() {
            Object value = this.resolver.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.resolver;
                synchronized (atomicReference) {
                    value = this.resolver.get();
                    if (value == null) {
                        Resolver actualValue = this.initResolver();
                        value = actualValue == null ? this.resolver : actualValue;
                        this.resolver.set(value);
                    }
                }
            }
            return (Resolver)(value == this.resolver ? null : value);
        }
    }
}

