/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core;

import io.microconfig.core.Microconfig;
import io.microconfig.core.configtypes.ConfigTypeFilters;
import io.microconfig.core.properties.Properties;
import io.microconfig.core.properties.PropertySerializer;
import io.microconfig.core.properties.serializers.PropertySerializers;
import io.microconfig.core.properties.templates.TemplatesService;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.List;
import lombok.Generated;

public class MicroconfigRunner {
    private final Microconfig microconfig;

    public MicroconfigRunner(File rootDir, File destinationDir) {
        this.microconfig = Microconfig.searchConfigsIn(rootDir).withDestinationDir(destinationDir);
    }

    public Properties buildProperties(String env, List<String> groups, List<String> services) {
        return this.microconfig.inEnvironment(env).findComponentsFrom(groups, services).getPropertiesFor(ConfigTypeFilters.eachConfigType()).resolveBy(this.microconfig.resolver()).forEachComponent(TemplatesService.resolveTemplatesBy(this.microconfig.resolver()));
    }

    public void build(String env, List<String> groups, List<String> services) {
        this.buildProperties(env, groups, services).save(this.toFiles());
    }

    public PropertySerializer<File> toFiles() {
        return PropertySerializers.withLegacySupport(PropertySerializers.toFileIn(this.microconfig.destinationDir(), PropertySerializers.withConfigDiff()), this.microconfig.environments());
    }

    @Generated
    public Microconfig getMicroconfig() {
        return this.microconfig;
    }

    @ConstructorProperties(value={"microconfig"})
    @Generated
    public MicroconfigRunner(Microconfig microconfig) {
        this.microconfig = microconfig;
    }
}

