/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.configtypes;

import io.microconfig.core.configtypes.ConfigType;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class ConfigTypeImpl
implements ConfigType {
    private final String name;
    private final Set<String> sourceExtensions;
    private final String resultFileName;

    public static ConfigType byName(String name) {
        return ConfigTypeImpl.byNameAndExtensions(name, Collections.singleton('.' + name), name);
    }

    public static ConfigType byNameAndExtensions(String name, Set<String> sourceExtensions, String resultFileName) {
        List badExtensions = StreamUtils.filter(sourceExtensions, ext -> !ext.startsWith("."));
        if (!badExtensions.isEmpty()) {
            throw new IllegalArgumentException("File extension must start with '.'. Current: " + badExtensions);
        }
        return new ConfigTypeImpl(name, sourceExtensions, resultFileName);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Set<String> getSourceExtensions() {
        return this.sourceExtensions;
    }

    @Generated
    public String getResultFileName() {
        return this.resultFileName;
    }

    @Generated
    public String toString() {
        return "ConfigTypeImpl(name=" + this.getName() + ", sourceExtensions=" + this.getSourceExtensions() + ", resultFileName=" + this.getResultFileName() + ")";
    }

    @ConstructorProperties(value={"name", "sourceExtensions", "resultFileName"})
    @Generated
    public ConfigTypeImpl(String name, Set<String> sourceExtensions, String resultFileName) {
        this.name = name;
        this.sourceExtensions = sourceExtensions;
        this.resultFileName = resultFileName;
    }
}

