/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.configtypes;

import io.microconfig.core.configtypes.ConfigType;
import io.microconfig.core.configtypes.ConfigTypeImpl;
import io.microconfig.core.configtypes.ConfigTypeRepository;
import io.microconfig.io.FsReader;
import io.microconfig.utils.Logger;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.yaml.snakeyaml.Yaml;

public class CustomConfigTypeRepository
implements ConfigTypeRepository {
    private static final String DESCRIPTOR = "microconfig.yaml";
    private final FsReader fsReader;
    private final File descriptorFile;

    public static ConfigTypeRepository findDescriptorIn(File rootDir, FsReader fsReader) {
        return new CustomConfigTypeRepository(fsReader, new File(rootDir, DESCRIPTOR));
    }

    public List<ConfigType> getConfigTypes() {
        if (!this.descriptorFile.exists()) {
            return Collections.emptyList();
        }
        List<ConfigType> types = this.parseConfigTypes();
        if (!types.isEmpty()) {
            Logger.announce((String)("Using settings from " + this.descriptorFile));
        }
        return types;
    }

    private List<ConfigType> parseConfigTypes() {
        try {
            return new MicroconfigDescriptor(this.fsReader.readFully(this.descriptorFile)).getConfigTypes();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Can't parse descriptor: " + this.descriptorFile, e);
        }
    }

    @ConstructorProperties(value={"fsReader", "descriptorFile"})
    @Generated
    public CustomConfigTypeRepository(FsReader fsReader, File descriptorFile) {
        this.fsReader = fsReader;
        this.descriptorFile = descriptorFile;
    }

    private static class MicroconfigDescriptor {
        private static final String CONFIG_TYPES = "configTypes";
        private static final String SOURCE_EXTENSIONS = "sourceExtensions";
        private static final String RESULT_FILE_NAME = "resultFileName";
        private final String content;

        private List<ConfigType> getConfigTypes() {
            Map types = (Map)new Yaml().load(this.content);
            List configTypes = types.getOrDefault(CONFIG_TYPES, Collections.emptyList());
            return StreamUtils.forEach(configTypes, this::parse);
        }

        private ConfigType parse(Object configTypeObject) {
            if (configTypeObject instanceof String) {
                return ConfigTypeImpl.byName(configTypeObject.toString());
            }
            Map configType = (Map)configTypeObject;
            String type = (String)configType.keySet().iterator().next();
            Map attributes = (Map)configType.get(type);
            LinkedHashSet<String> sourceExtensions = attributes.containsKey(SOURCE_EXTENSIONS) ? new LinkedHashSet((List)attributes.get(SOURCE_EXTENSIONS)) : Collections.singleton(type);
            String resultFileName = attributes.getOrDefault(RESULT_FILE_NAME, type);
            return ConfigTypeImpl.byNameAndExtensions(type, sourceExtensions, resultFileName);
        }

        @ConstructorProperties(value={"content"})
        @Generated
        public MicroconfigDescriptor(String content) {
            this.content = content;
        }
    }
}

