/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.environments;

import io.microconfig.core.environments.Component;
import io.microconfig.core.environments.ComponentFactory;
import io.microconfig.core.environments.ComponentGroup;
import io.microconfig.core.environments.Components;
import io.microconfig.core.environments.ComponentsImpl;
import io.microconfig.core.environments.Environment;
import io.microconfig.core.properties.PropertiesFactory;
import io.microconfig.core.properties.repository.ComponentNotFoundException;
import io.microconfig.utils.Logger;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public class EnvironmentImpl
implements Environment {
    private final File source;
    private final String name;
    private final int portOffset;
    private final List<ComponentGroup> groups;
    private final ComponentFactory componentFactory;
    private final PropertiesFactory propertiesFactory;

    public List<ComponentGroup> findGroupsWithIp(String ip) {
        return StreamUtils.filter(this.groups, g -> g.getIp().filter(ip::equals).isPresent());
    }

    public ComponentGroup getGroupWithName(String groupName) {
        return this.findGroup(group -> group.getName().equals(groupName), () -> "groupName=" + groupName);
    }

    public Optional<ComponentGroup> findGroupWithComponent(String componentName) {
        return this.groups.stream().filter(g -> g.findComponentWithName(componentName).isPresent()).findFirst();
    }

    public Components getAllComponents() {
        List<Component> components = this.groups.stream().map(ComponentGroup::getComponents).map(Components::asList).flatMap(Collection::stream).collect(Collectors.toList());
        return new ComponentsImpl(components, this.propertiesFactory);
    }

    public Component getComponentWithName(String componentName) {
        return (Component)StreamUtils.findFirstResult(this.groups, g -> g.findComponentWithName(componentName)).orElseThrow(() -> new ComponentNotFoundException(componentName));
    }

    public Components findComponentsFrom(List<String> groups, List<String> componentNames) {
        List<Component> componentsFromGroups = this.componentsFrom(groups);
        List<Component> result = this.filterBy(componentNames, componentsFromGroups);
        Logger.info((String)("Filtered " + result.size() + " component(s) in [" + this.name + "] env."));
        return new ComponentsImpl(result, this.propertiesFactory);
    }

    public Component findComponentWithName(String componentName) {
        return StreamUtils.findFirstResult(this.groups, g -> g.findComponentWithName(componentName)).orElseGet(() -> this.componentFactory.createComponent(componentName, componentName, this.name));
    }

    private List<Component> componentsFrom(List<String> groups) {
        if (groups.isEmpty()) {
            return this.getAllComponents().asList();
        }
        return groups.stream().map(this::getGroupWithName).map(ComponentGroup::getComponents).map(Components::asList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Component> filterBy(List<String> components, List<Component> componentFromGroups) {
        if (components.isEmpty()) {
            return componentFromGroups;
        }
        Map componentByName = componentFromGroups.stream().collect(Collectors.toMap(Component::getName, Function.identity()));
        return StreamUtils.forEach(components, c -> this.componentOrEx(componentByName, (String)c));
    }

    private Component componentOrEx(Map<String, Component> componentByName, String component) {
        Component c = componentByName.get(component);
        if (c == null) {
            throw new ComponentNotFoundException(component);
        }
        return c;
    }

    private ComponentGroup findGroup(Predicate<ComponentGroup> groupPredicate, Supplier<String> description) {
        return this.groups.stream().filter(groupPredicate).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find group by filter: '" + (String)description.get() + "' in env '" + this.name + "'"));
    }

    public String toString() {
        return this.name + ": " + this.groups;
    }

    @ConstructorProperties(value={"source", "name", "portOffset", "groups", "componentFactory", "propertiesFactory"})
    @Generated
    public EnvironmentImpl(File source, String name, int portOffset, List<ComponentGroup> groups, ComponentFactory componentFactory, PropertiesFactory propertiesFactory) {
        this.source = source;
        this.name = name;
        this.portOffset = portOffset;
        this.groups = groups;
        this.componentFactory = componentFactory;
        this.propertiesFactory = propertiesFactory;
    }

    @Generated
    public File getSource() {
        return this.source;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getPortOffset() {
        return this.portOffset;
    }

    @Generated
    public List<ComponentGroup> getGroups() {
        return this.groups;
    }
}

