/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.environments.repository;

import io.microconfig.core.environments.ComponentFactory;
import io.microconfig.core.environments.ComponentGroup;
import io.microconfig.core.environments.ComponentGroupImpl;
import io.microconfig.core.environments.ComponentsImpl;
import io.microconfig.core.environments.repository.ComponentDefinition;
import io.microconfig.core.properties.PropertiesFactory;
import io.microconfig.utils.CollectionUtils;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

class ComponentGroupDefinition {
    private final String name;
    private final String ip;
    private final List<ComponentDefinition> components;
    private final List<ComponentDefinition> excludedComponents;
    private final List<ComponentDefinition> appendedComponents;

    public ComponentGroupDefinition overrideBy(ComponentGroupDefinition override) {
        return this.getIpFrom(override).getComponentsFrom(override).getExcludedGroupsFrom(override).getAppendedGroupsFrom(override);
    }

    private ComponentGroupDefinition getIpFrom(ComponentGroupDefinition override) {
        return override.ip == null ? this : this.withIp(override.ip);
    }

    private ComponentGroupDefinition getComponentsFrom(ComponentGroupDefinition override) {
        return override.components.isEmpty() ? this : this.withComponents(override.components);
    }

    private ComponentGroupDefinition getExcludedGroupsFrom(ComponentGroupDefinition override) {
        return override.excludedComponents.isEmpty() ? this : this.excludeComponents(override.excludedComponents);
    }

    private ComponentGroupDefinition getAppendedGroupsFrom(ComponentGroupDefinition override) {
        return override.appendedComponents.isEmpty() ? this : this.joinComponentsWith(override.appendedComponents);
    }

    private ComponentGroupDefinition excludeComponents(List<ComponentDefinition> toExclude) {
        return this.withComponents(CollectionUtils.minus(this.components, toExclude)).withExcludedComponents(Collections.emptyList());
    }

    private ComponentGroupDefinition joinComponentsWith(List<ComponentDefinition> newAppendedComponents) {
        return this.withComponents(CollectionUtils.join(this.components, newAppendedComponents)).withAppendedComponents(Collections.emptyList());
    }

    public ComponentGroup toGroup(ComponentFactory componentFactory, PropertiesFactory propertiesFactory, String environment) {
        return new ComponentGroupImpl(this.name, this.ip, new ComponentsImpl(StreamUtils.forEach(this.components, c -> c.toComponent(componentFactory, environment)), propertiesFactory));
    }

    @Generated
    public ComponentGroupDefinition withName(String name) {
        return this.name == name ? this : new ComponentGroupDefinition(name, this.ip, this.components, this.excludedComponents, this.appendedComponents);
    }

    @Generated
    public ComponentGroupDefinition withIp(String ip) {
        return this.ip == ip ? this : new ComponentGroupDefinition(this.name, ip, this.components, this.excludedComponents, this.appendedComponents);
    }

    @Generated
    public ComponentGroupDefinition withComponents(List<ComponentDefinition> components) {
        return this.components == components ? this : new ComponentGroupDefinition(this.name, this.ip, components, this.excludedComponents, this.appendedComponents);
    }

    @Generated
    public ComponentGroupDefinition withExcludedComponents(List<ComponentDefinition> excludedComponents) {
        return this.excludedComponents == excludedComponents ? this : new ComponentGroupDefinition(this.name, this.ip, this.components, excludedComponents, this.appendedComponents);
    }

    @Generated
    public ComponentGroupDefinition withAppendedComponents(List<ComponentDefinition> appendedComponents) {
        return this.appendedComponents == appendedComponents ? this : new ComponentGroupDefinition(this.name, this.ip, this.components, this.excludedComponents, appendedComponents);
    }

    @ConstructorProperties(value={"name", "ip", "components", "excludedComponents", "appendedComponents"})
    @Generated
    public ComponentGroupDefinition(String name, String ip, List<ComponentDefinition> components, List<ComponentDefinition> excludedComponents, List<ComponentDefinition> appendedComponents) {
        this.name = name;
        this.ip = ip;
        this.components = components;
        this.excludedComponents = excludedComponents;
        this.appendedComponents = appendedComponents;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<ComponentDefinition> getComponents() {
        return this.components;
    }
}

