/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.environments.repository;

import io.microconfig.core.environments.ComponentFactory;
import io.microconfig.core.environments.Environment;
import io.microconfig.core.environments.EnvironmentImpl;
import io.microconfig.core.environments.repository.ComponentDefinition;
import io.microconfig.core.environments.repository.ComponentGroupDefinition;
import io.microconfig.core.environments.repository.EnvInclude;
import io.microconfig.core.properties.PropertiesFactory;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

class EnvironmentDefinition {
    private final File source;
    private final String name;
    private final String ip;
    private final int portOffset;
    private final EnvInclude envInclude;
    private final List<ComponentGroupDefinition> groups;

    public EnvironmentDefinition processIncludeUsing(Function<String, EnvironmentDefinition> environmentRepository) {
        return this.envInclude.isEmpty() ? this : this.envInclude.includeTo(this, environmentRepository);
    }

    public EnvironmentDefinition checkComponentNamesAreUnique() {
        List notUniqueComponents = this.groups.stream().map(ComponentGroupDefinition::getComponents).flatMap(Collection::stream).collect(Collectors.groupingBy(ComponentDefinition::getName, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!notUniqueComponents.isEmpty()) {
            throw new IllegalStateException("Environment '" + this.name + "' contains several declarations of: " + notUniqueComponents);
        }
        return this;
    }

    public Environment toEnvironment(ComponentFactory componentFactory, PropertiesFactory propertiesFactory) {
        return new EnvironmentImpl(this.source, this.name, this.portOffset, StreamUtils.forEach(this.groups, g -> g.toGroup(componentFactory, propertiesFactory, this.name)), componentFactory, propertiesFactory);
    }

    @Generated
    public EnvironmentDefinition withSource(File source) {
        return this.source == source ? this : new EnvironmentDefinition(source, this.name, this.ip, this.portOffset, this.envInclude, this.groups);
    }

    @Generated
    public EnvironmentDefinition withName(String name) {
        return this.name == name ? this : new EnvironmentDefinition(this.source, name, this.ip, this.portOffset, this.envInclude, this.groups);
    }

    @Generated
    public EnvironmentDefinition withIp(String ip) {
        return this.ip == ip ? this : new EnvironmentDefinition(this.source, this.name, ip, this.portOffset, this.envInclude, this.groups);
    }

    @Generated
    public EnvironmentDefinition withPortOffset(int portOffset) {
        return this.portOffset == portOffset ? this : new EnvironmentDefinition(this.source, this.name, this.ip, portOffset, this.envInclude, this.groups);
    }

    @Generated
    public EnvironmentDefinition withEnvInclude(EnvInclude envInclude) {
        return this.envInclude == envInclude ? this : new EnvironmentDefinition(this.source, this.name, this.ip, this.portOffset, envInclude, this.groups);
    }

    @Generated
    public EnvironmentDefinition withGroups(List<ComponentGroupDefinition> groups) {
        return this.groups == groups ? this : new EnvironmentDefinition(this.source, this.name, this.ip, this.portOffset, this.envInclude, groups);
    }

    @ConstructorProperties(value={"source", "name", "ip", "portOffset", "envInclude", "groups"})
    @Generated
    public EnvironmentDefinition(File source, String name, String ip, int portOffset, EnvInclude envInclude, List<ComponentGroupDefinition> groups) {
        this.source = source;
        this.name = name;
        this.ip = ip;
        this.portOffset = portOffset;
        this.envInclude = envInclude;
        this.groups = groups;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public List<ComponentGroupDefinition> getGroups() {
        return this.groups;
    }
}

