/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.environments.repository;

import com.google.gson.Gson;
import io.microconfig.core.environments.repository.ComponentDefinition;
import io.microconfig.core.environments.repository.ComponentGroupDefinition;
import io.microconfig.core.environments.repository.EnvInclude;
import io.microconfig.core.environments.repository.EnvironmentDefinition;
import io.microconfig.core.environments.repository.EnvironmentException;
import io.microconfig.io.FsReader;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.yaml.snakeyaml.Yaml;

class EnvironmentFile {
    private static final String IP = "ip";
    private static final String PORT_OFFSET = "portOffset";
    private static final String INCLUDE = "include";
    private static final String INCLUDE_ENV = "env";
    private static final String EXCLUDE = "exclude";
    private static final String APPEND = "append";
    private static final String COMPONENTS = "components";
    private final File file;

    public EnvironmentDefinition parseUsing(FsReader fsReader) {
        String name = FileUtils.getName((File)this.file);
        try {
            return this.parse(this.parseToMap(fsReader), name);
        }
        catch (RuntimeException e) {
            throw new EnvironmentException("Can't parse environment '" + name + "'", e);
        }
    }

    private Map<String, Object> parseToMap(FsReader reader) {
        String content = reader.readFully(this.file);
        return this.file.getName().endsWith(".json") ? (Map)new Gson().fromJson(content, Map.class) : (Map)new Yaml().load(content);
    }

    private EnvironmentDefinition parse(Map<String, Object> keyValue, String name) {
        EnvInclude envInclude = this.parseInclude(keyValue);
        int portOffset = this.parsePortOffset(keyValue);
        String envIp = this.parseIp(keyValue);
        List<ComponentGroupDefinition> componentGroups = this.parseComponentGroups(keyValue, envIp);
        return new EnvironmentDefinition(this.file, name, envIp, portOffset, envInclude, componentGroups);
    }

    private EnvInclude parseInclude(Map<String, Object> keyValue) {
        Map includeProps = (Map)keyValue.remove(INCLUDE);
        if (includeProps == null) {
            return EnvInclude.empty();
        }
        String name = (String)includeProps.get(INCLUDE_ENV);
        Collection excludes = includeProps.getOrDefault(EXCLUDE, Collections.emptyList());
        return new EnvInclude(name, new LinkedHashSet<String>(excludes));
    }

    private int parsePortOffset(Map<String, ?> keyValue) {
        Number offset = (Number)keyValue.remove(PORT_OFFSET);
        return offset == null ? 0 : offset.intValue();
    }

    private String parseIp(Map<String, ?> keyValue) {
        return (String)keyValue.remove(IP);
    }

    private List<ComponentGroupDefinition> parseComponentGroups(Map<String, Object> keyValue, String envIp) {
        return StreamUtils.forEach(keyValue.entrySet(), groupEntry -> {
            try {
                return this.parseGroup((Map.Entry<String, Object>)groupEntry, envIp);
            }
            catch (RuntimeException e) {
                throw new EnvironmentException("Can't parse group declaration: '" + groupEntry + "'", e);
            }
        });
    }

    private ComponentGroupDefinition parseGroup(Map.Entry<String, Object> componentGroupDeclaration, String envIp) {
        String componentGroupName = componentGroupDeclaration.getKey();
        Map properties = (Map)componentGroupDeclaration.getValue();
        String ip = properties.getOrDefault(IP, envIp);
        List<ComponentDefinition> parsedComponents = this.parseComponents(properties, COMPONENTS);
        List<ComponentDefinition> excludedComponents = this.parseComponents(properties, EXCLUDE);
        List<ComponentDefinition> appendedComponents = this.parseComponents(properties, APPEND);
        return new ComponentGroupDefinition(componentGroupName, ip, parsedComponents, excludedComponents, appendedComponents);
    }

    private List<ComponentDefinition> parseComponents(Map<String, Object> keyValue, String property) {
        List values = (List)keyValue.get(property);
        if (values == null) {
            return Collections.emptyList();
        }
        return values.stream().filter(Objects::nonNull).map(this::toComponentDefinition).collect(Collectors.toList());
    }

    private ComponentDefinition toComponentDefinition(String s) {
        String[] parts = s.split(":");
        if (parts.length > 2) {
            throw new IllegalArgumentException("Incorrect component declaration: " + s);
        }
        return parts.length == 1 ? ComponentDefinition.withName(parts[0]) : ComponentDefinition.withAlias(parts[0], parts[1]);
    }

    @ConstructorProperties(value={"file"})
    @Generated
    public EnvironmentFile(File file) {
        this.file = file;
    }
}

