/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties;

import io.microconfig.core.configtypes.ConfigType;
import io.microconfig.core.properties.Properties;
import io.microconfig.core.properties.PropertiesFactory;
import io.microconfig.core.properties.PropertiesImpl;
import io.microconfig.core.properties.PropertiesRepository;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.core.properties.TypedPropertiesImpl;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;

public class PropertiesFactoryImpl
implements PropertiesFactory {
    private final PropertiesRepository propertiesRepository;

    public Properties getPropertiesOf(String componentName, String componentOriginalName, String environment, List<ConfigType> configTypes) {
        return new PropertiesImpl(StreamUtils.forEach(configTypes, this.readConfigsFor(componentName, componentOriginalName, environment)));
    }

    public Properties flat(List<Properties> properties) {
        return PropertiesImpl.flat(properties);
    }

    private Function<ConfigType, TypedProperties> readConfigsFor(String componentName, String componentOriginalName, String environment) {
        return configType -> {
            Map<String, Property> properties = this.propertiesRepository.getPropertiesOf(componentOriginalName, environment, (ConfigType)configType);
            return new TypedPropertiesImpl((ConfigType)configType, componentName, environment, properties, Collections.emptyList());
        };
    }

    @ConstructorProperties(value={"propertiesRepository"})
    @Generated
    public PropertiesFactoryImpl(PropertiesRepository propertiesRepository) {
        this.propertiesRepository = propertiesRepository;
    }
}

