/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties;

import io.microconfig.core.exceptions.MicroconfigException;
import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.Property;
import io.microconfig.utils.StringUtils;
import java.util.Optional;
import lombok.Generated;

public class ResolveException
extends MicroconfigException {
    private final DeclaringComponent current;
    private final DeclaringComponent root;
    private Property property;

    public ResolveException(DeclaringComponent current, DeclaringComponent root, String message) {
        super(message);
        this.root = root;
        this.current = current;
        this.property = null;
    }

    public ResolveException(DeclaringComponent current, DeclaringComponent root, String message, Throwable cause) {
        super(message, cause);
        this.root = root;
        this.current = current;
        this.property = null;
    }

    public String getMessage() {
        return this.rootComponentInfo() + this.problemInfo();
    }

    private String problemInfo() {
        return this.exceptionInfo() + super.getMessage() + "\n" + this.causeMessage();
    }

    private String rootComponentInfo() {
        return "Can't build configs for root component '" + this.root + "'.\n";
    }

    private String exceptionInfo() {
        return "Exception in\n\t" + this.current + "'\n" + this.propertyMessage();
    }

    private String propertyMessage() {
        return Optional.ofNullable(this.property).map(p -> "\t" + p + "\n").orElse("");
    }

    private String causeMessage() {
        if (this.getCause() instanceof ResolveException) {
            return "Cause: " + ((ResolveException)((Object)this.getCause())).problemInfo();
        }
        return StringUtils.getCauseMessage((Throwable)((Object)this));
    }

    @Generated
    public void setProperty(Property property) {
        this.property = property;
    }
}

