/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.io.properties;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.io.ConfigWriter;
import io.microconfig.utils.FileUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

class PropertiesWriter
implements ConfigWriter {
    private final File file;

    @Override
    public void write(Map<String, String> properties) {
        this.doWrite(this.serializeMap(properties), new OpenOption[0]);
    }

    @Override
    public void write(Collection<Property> properties) {
        this.doWrite(this.serialize(properties), new OpenOption[0]);
    }

    @Override
    public String serialize(Collection<Property> properties) {
        return properties.stream().filter(p -> !p.isVar()).map(Object::toString).collect(Collectors.joining(FileUtils.LINES_SEPARATOR));
    }

    private String serializeMap(Map<String, String> properties) {
        return properties.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(FileUtils.LINES_SEPARATOR));
    }

    private void doWrite(String lines, OpenOption ... openOptions) {
        FileUtils.write((Path)this.file.toPath(), (String)lines, (OpenOption[])openOptions);
    }

    @ConstructorProperties(value={"file"})
    @Generated
    public PropertiesWriter(File file) {
        this.file = file;
    }
}

