/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.io.selector;

import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.PropertyImpl;
import io.microconfig.core.properties.io.selector.ConfigFormatDetector;
import io.microconfig.io.FsReader;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.function.Predicate;
import lombok.Generated;

public class ConfigFormatDetectorImpl
implements ConfigFormatDetector {
    private final FsReader reader;

    @Override
    public ConfigFormat detectConfigFormat(File file) {
        if (file.getName().endsWith(ConfigFormat.PROPERTIES.extension())) {
            return ConfigFormat.PROPERTIES;
        }
        if (file.getName().endsWith(ConfigFormat.YAML.extension())) {
            return ConfigFormat.YAML;
        }
        return this.hasYamlOffsets(file) ? ConfigFormat.YAML : ConfigFormat.PROPERTIES;
    }

    private boolean hasYamlOffsets(File file) {
        if (!file.exists()) {
            return false;
        }
        String firstProperty = this.reader.firstLineOf(file, this.withValue()).orElse(null);
        if (firstProperty == null) {
            return false;
        }
        int separatorIndex = PropertyImpl.findSeparatorIndexIn(firstProperty);
        if (separatorIndex < 0) {
            throw new IllegalArgumentException("Incorrect property " + firstProperty + " in " + file);
        }
        return firstProperty.charAt(separatorIndex) == ':';
    }

    private Predicate<String> withValue() {
        return line -> {
            String trimmed = line.trim();
            return !trimmed.isEmpty() && !PropertyImpl.isComment(trimmed);
        };
    }

    @ConstructorProperties(value={"reader"})
    @Generated
    public ConfigFormatDetectorImpl(FsReader reader) {
        this.reader = reader;
    }
}

