/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.io.selector;

import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.io.ConfigIo;
import io.microconfig.core.properties.io.ConfigReader;
import io.microconfig.core.properties.io.ConfigWriter;
import io.microconfig.core.properties.io.selector.ConfigFormatDetector;
import java.beans.ConstructorProperties;
import java.io.File;
import lombok.Generated;

public class ConfigIoSelector
implements ConfigIo {
    private final ConfigFormatDetector configFormatDetector;
    private final ConfigIo yamlFormat;
    private final ConfigIo propertiesFormat;

    @Override
    public ConfigReader readFrom(File file) {
        return this.select(file).readFrom(file);
    }

    @Override
    public ConfigWriter writeTo(File file) {
        return this.select(file).writeTo(file);
    }

    private ConfigIo select(File file) {
        ConfigFormat format = this.configFormatDetector.detectConfigFormat(file);
        if (format == ConfigFormat.YAML) {
            return this.yamlFormat;
        }
        if (format == ConfigFormat.PROPERTIES) {
            return this.propertiesFormat;
        }
        throw new IllegalStateException("Unsupported format " + format + " for " + file);
    }

    @ConstructorProperties(value={"configFormatDetector", "yamlFormat", "propertiesFormat"})
    @Generated
    public ConfigIoSelector(ConfigFormatDetector configFormatDetector, ConfigIo yamlFormat, ConfigIo propertiesFormat) {
        this.configFormatDetector = configFormatDetector;
        this.yamlFormat = yamlFormat;
        this.propertiesFormat = propertiesFormat;
    }
}

