/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.repository;

import io.microconfig.core.configtypes.ConfigType;
import io.microconfig.core.properties.repository.ComponentGraph;
import io.microconfig.core.properties.repository.ComponentNotFoundException;
import io.microconfig.core.properties.repository.ConfigFile;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.Logger;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ComponentGraphImpl
implements ComponentGraph {
    public static final String COMPONENTS_DIR = "components";
    private final Map<String, List<File>> foldersByComponentType;

    public static ComponentGraph traverseFrom(File rootDir) {
        File componentDir = new File(rootDir, COMPONENTS_DIR);
        if (!componentDir.exists()) {
            throw new IllegalArgumentException("Root directory must contain 'components' dir");
        }
        try (Stream paths = FileUtils.walk((Path)componentDir.toPath());){
            ComponentGraphImpl componentGraphImpl = new ComponentGraphImpl(ComponentGraphImpl.collectFoldersByComponentType(paths));
            return componentGraphImpl;
        }
    }

    private static Map<String, List<File>> collectFoldersByComponentType(Stream<Path> pathStream) {
        return ((Stream)pathStream.parallel()).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.groupingBy(File::getName));
    }

    @Override
    public List<ConfigFile> getConfigFilesOf(String component, String environment, ConfigType configType) {
        List dirs = this.foldersByComponentType.getOrDefault(component, Collections.emptyList());
        if (dirs.isEmpty()) {
            throw new ComponentNotFoundException(component);
        }
        return dirs.stream().map(File::listFiles).filter(Objects::nonNull).flatMap(Stream::of).filter(this.configWith(configType).and(this.forEnv(environment))).sorted(this.configPriority()).map(f -> new ConfigFile((File)f, configType.getName(), environment)).collect(Collectors.toList());
    }

    private Predicate<File> configWith(ConfigType configType) {
        return f -> configType.getSourceExtensions().contains(FileUtils.getExtension((File)f));
    }

    private Predicate<File> forEnv(String environment) {
        return f -> StringUtils.dotCountIn((String)f.getName()) == 1L || StringUtils.isEmpty((String)environment) || f.getName().contains('.' + environment + '.');
    }

    private Comparator<File> configPriority() {
        return Comparator.comparing(this::amountOfEnvironments).thenComparing(File::getName);
    }

    private long amountOfEnvironments(File f) {
        long envCount = StringUtils.dotCountIn((String)f.getName()) - 1L;
        if (envCount == 0L) {
            return Long.MIN_VALUE;
        }
        return -1L * envCount;
    }

    @Override
    public Optional<File> getFolderOf(String component) {
        List folders = this.foldersByComponentType.getOrDefault(component, Collections.emptyList());
        if (folders.size() > 1) {
            Logger.warn((String)("Found " + folders.size() + " folders with name '" + component + "'. Consider renaming them, otherwise placeholder resolution works incorrectly"));
        }
        return folders.isEmpty() ? Optional.empty() : Optional.of(folders.get(0));
    }

    @ConstructorProperties(value={"foldersByComponentType"})
    @Generated
    private ComponentGraphImpl(Map<String, List<File>> foldersByComponentType) {
        this.foldersByComponentType = foldersByComponentType;
    }
}

