/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.repository;

import io.microconfig.core.configtypes.ConfigType;
import io.microconfig.core.properties.PropertiesRepository;
import io.microconfig.core.properties.Property;
import io.microconfig.utils.CollectionUtils;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CompositePropertiesRepository
implements PropertiesRepository {
    private final List<PropertiesRepository> repositories;

    public static PropertiesRepository compositeOf(List<PropertiesRepository> list, PropertiesRepository ... repos) {
        List joined = CollectionUtils.join(list, Arrays.asList(repos));
        return joined.size() == 1 ? (PropertiesRepository)CollectionUtils.singleValue((Collection)joined) : new CompositePropertiesRepository(joined);
    }

    @Override
    public Map<String, Property> getPropertiesOf(String originalComponentName, String environment, ConfigType configType) {
        return this.repositories.stream().map(r -> r.getPropertiesOf(originalComponentName, environment, configType)).reduce(new LinkedHashMap(), this::mergeSecondToFirst);
    }

    private Map<String, Property> mergeSecondToFirst(Map<String, Property> one, Map<String, Property> two) {
        two.forEach(one::putIfAbsent);
        return one;
    }

    @ConstructorProperties(value={"repositories"})
    @Generated
    public CompositePropertiesRepository(List<PropertiesRepository> repositories) {
        this.repositories = repositories;
    }
}

