/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.repository;

import io.microconfig.core.properties.repository.Include;
import io.microconfig.utils.StreamUtils;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import lombok.Generated;

public class Includes {
    private static final String PREFIX = "#include ";
    private static final String PREFIX2 = "#@include ";
    private final String line;

    public static boolean isInclude(String line) {
        String lower = line.toLowerCase();
        return lower.startsWith(PREFIX) || lower.startsWith(PREFIX2);
    }

    public static Includes from(String line) {
        return new Includes(line);
    }

    public List<Include> withDefaultEnv(String defaultEnv) {
        try {
            return this.parseIncludes(defaultEnv);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Can't parse include '" + this.line + "'. Supported format: #include component[optionalEnv], component2", e);
        }
    }

    private List<Include> parseIncludes(String defaultEnv) {
        List components = StringUtils.split((String)this.line.substring(this.componentStartIndex()), (String)",");
        if (components.isEmpty()) {
            throw new IllegalArgumentException("Include must contain component names.");
        }
        return StreamUtils.forEach((Collection)components, component -> Include.parse(component, defaultEnv));
    }

    private int componentStartIndex() {
        String lower = this.line.toLowerCase();
        int index = this.tryPrefix(lower, PREFIX);
        if (index >= 0) {
            return index;
        }
        int index2 = this.tryPrefix(lower, PREFIX2);
        if (index2 >= 0) {
            return index2;
        }
        throw new IllegalArgumentException("Include must start with #include  or #@include ");
    }

    private int tryPrefix(String value, String prefix) {
        int start = value.indexOf(prefix);
        return start >= 0 ? start + prefix.length() : -1;
    }

    @ConstructorProperties(value={"line"})
    @Generated
    private Includes(String line) {
        this.line = line;
    }
}

