/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.resolvers.expression.functions;

import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomStringApi {
    public static String findGroup(String regex, String line) {
        return CustomStringApi.findGroupOrDefault(regex, line, "");
    }

    public static String findGroupOrDefault(String regex, String line, String defaultValue) {
        Matcher matcher = Pattern.compile(regex).matcher(line);
        return matcher.find() ? matcher.group(Math.min(1, matcher.groupCount())) : defaultValue;
    }

    public static String base64(String line) {
        return Base64.getEncoder().encodeToString(line.getBytes());
    }

    public static String delete(String line, String toDelete) {
        return line.replace(toDelete, "");
    }

    public static String substringAfterFirst(String line, String substring) {
        int i = line.indexOf(substring);
        return CustomStringApi.substringAfter(line, i, substring);
    }

    public static String substringAfterLast(String line, String substring) {
        int i = line.lastIndexOf(substring);
        return CustomStringApi.substringAfter(line, i, substring);
    }

    private static String substringAfter(String line, int i, String substring) {
        if (i < 0) {
            return "";
        }
        return line.substring(i + substring.length());
    }
}

