/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.resolvers.placeholder;

import io.microconfig.core.properties.resolvers.placeholder.Placeholder;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;

public class PlaceholderBorders {
    private final StringBuilder line;
    private final int startIndex;
    private final int configTypeEndIndex;
    private final int envIndex;
    private final int keyIndex;
    private final int defaultValueIndex;
    private final int endIndex;

    public static Optional<PlaceholderBorders> findPlaceholderIn(CharSequence line) {
        return PlaceholderBorders.findPlaceholderIn(line, 0);
    }

    public static Optional<PlaceholderBorders> findPlaceholderIn(CharSequence line, int startIndex) {
        return new PlaceholderBorders(StringUtils.asStringBuilder((CharSequence)line)).withStartIndex(startIndex).searchOpenSign();
    }

    private PlaceholderBorders(StringBuilder line) {
        this(line, -1, -1, -1, -1, -1, -1);
    }

    private Optional<PlaceholderBorders> searchOpenSign() {
        int index = this.line.indexOf("${", this.startIndex);
        if (index >= 0) {
            return new PlaceholderBorders(this.line).withStartIndex(index).parseComponentName();
        }
        return Optional.empty();
    }

    private Optional<PlaceholderBorders> parseComponentName() {
        for (int i = Integer.max(this.startIndex + 2, this.configTypeEndIndex + 3); i < this.line.length(); ++i) {
            char c = this.line.charAt(i);
            if (c == ':' && i + 1 < this.line.length() && this.line.charAt(i + 1) == ':') {
                return this.withConfigTypeEndIndex(i - 1).parseComponentName();
            }
            if (c == '[') {
                return this.withEnvIndex(i + 1).parseEnvName();
            }
            if (c == '@') {
                return this.startIndex + 2 == i ? this.withStartIndex(i).searchOpenSign() : this.withKeyIndex(i + 1).parseKey();
            }
            if (!this.notAllowedSymbol(c)) continue;
            return this.withStartIndex(i).searchOpenSign();
        }
        return Optional.empty();
    }

    private Optional<PlaceholderBorders> parseEnvName() {
        for (int i = this.envIndex; i < this.line.length(); ++i) {
            char c = this.line.charAt(i);
            if (c == ']' && i + 1 < this.line.length() && this.line.charAt(i + 1) == '@') {
                return this.withKeyIndex(i + 2).parseKey();
            }
            if (!this.notAllowedSymbol(c)) continue;
            return this.withStartIndex(i).searchOpenSign();
        }
        return Optional.empty();
    }

    private Optional<PlaceholderBorders> parseKey() {
        for (int i = this.keyIndex; i < this.line.length(); ++i) {
            char c = this.line.charAt(i);
            if (c == ':') {
                return this.withDefaultValueIndex(i + 1).parseDefaultValue();
            }
            if (c == '}') {
                return this.keyIndex == i ? this.withStartIndex(i).searchOpenSign() : Optional.of(this.withEndIndex(i + 1));
            }
            if (!this.notAllowedSymbol(c) || c == '*' || c == '/' || c == '\\') continue;
            return this.withStartIndex(i).searchOpenSign();
        }
        return Optional.empty();
    }

    private Optional<PlaceholderBorders> parseDefaultValue() {
        int closeBracketLastIndex = -1;
        int openBrackets = 1;
        for (int i = this.defaultValueIndex; i < this.line.length(); ++i) {
            char c = this.line.charAt(i);
            if (c == '{') {
                char prevChar = this.line.charAt(i - 1);
                if (prevChar != '$' && prevChar != '#') continue;
                ++openBrackets;
                continue;
            }
            if (c != '}') continue;
            closeBracketLastIndex = i;
            if (--openBrackets != 0) continue;
            return Optional.of(this.withEndIndex(closeBracketLastIndex + 1));
        }
        return closeBracketLastIndex < 0 ? Optional.empty() : Optional.of(this.withEndIndex(closeBracketLastIndex + 1));
    }

    private boolean notAllowedSymbol(char c) {
        return !Character.isLetterOrDigit(c) && c != '.' && c != '_' && c != '-';
    }

    private String getConfigType(String contextConfigType) {
        return this.configTypeEndIndex < 0 ? contextConfigType : this.line.substring(this.startIndex + 2, this.configTypeEndIndex + 1);
    }

    private String getComponent() {
        return this.line.substring(Integer.max(this.startIndex + 2, this.configTypeEndIndex + 3), this.envIndex < 0 ? this.keyIndex - 1 : this.envIndex - 1);
    }

    private String getEnvironment(String contextEnv) {
        return this.envIndex < 0 ? contextEnv : this.line.subSequence(this.envIndex, this.keyIndex - 2).toString();
    }

    private String getKey() {
        return this.line.substring(this.keyIndex, this.defaultValueIndex < 0 ? this.endIndex - 1 : this.defaultValueIndex - 1);
    }

    private String getDefaultValue() {
        return this.defaultValueIndex < 0 ? null : this.line.substring(this.defaultValueIndex, this.endIndex - 1);
    }

    public Placeholder toPlaceholder(String contextConfigType, String contextEnv) {
        return new Placeholder(this.getConfigType(contextConfigType), this.getComponent(), this.getEnvironment(contextEnv), this.getKey(), this.getDefaultValue());
    }

    public String toString() {
        return this.startIndex < 0 ? "" : this.line.substring(this.startIndex, this.endIndex);
    }

    @Generated
    private PlaceholderBorders withLine(StringBuilder line) {
        return this.line == line ? this : new PlaceholderBorders(line, this.startIndex, this.configTypeEndIndex, this.envIndex, this.keyIndex, this.defaultValueIndex, this.endIndex);
    }

    @Generated
    private PlaceholderBorders withStartIndex(int startIndex) {
        return this.startIndex == startIndex ? this : new PlaceholderBorders(this.line, startIndex, this.configTypeEndIndex, this.envIndex, this.keyIndex, this.defaultValueIndex, this.endIndex);
    }

    @Generated
    private PlaceholderBorders withConfigTypeEndIndex(int configTypeEndIndex) {
        return this.configTypeEndIndex == configTypeEndIndex ? this : new PlaceholderBorders(this.line, this.startIndex, configTypeEndIndex, this.envIndex, this.keyIndex, this.defaultValueIndex, this.endIndex);
    }

    @Generated
    private PlaceholderBorders withEnvIndex(int envIndex) {
        return this.envIndex == envIndex ? this : new PlaceholderBorders(this.line, this.startIndex, this.configTypeEndIndex, envIndex, this.keyIndex, this.defaultValueIndex, this.endIndex);
    }

    @Generated
    private PlaceholderBorders withKeyIndex(int keyIndex) {
        return this.keyIndex == keyIndex ? this : new PlaceholderBorders(this.line, this.startIndex, this.configTypeEndIndex, this.envIndex, keyIndex, this.defaultValueIndex, this.endIndex);
    }

    @Generated
    private PlaceholderBorders withDefaultValueIndex(int defaultValueIndex) {
        return this.defaultValueIndex == defaultValueIndex ? this : new PlaceholderBorders(this.line, this.startIndex, this.configTypeEndIndex, this.envIndex, this.keyIndex, defaultValueIndex, this.endIndex);
    }

    @Generated
    private PlaceholderBorders withEndIndex(int endIndex) {
        return this.endIndex == endIndex ? this : new PlaceholderBorders(this.line, this.startIndex, this.configTypeEndIndex, this.envIndex, this.keyIndex, this.defaultValueIndex, endIndex);
    }

    @ConstructorProperties(value={"line", "startIndex", "configTypeEndIndex", "envIndex", "keyIndex", "defaultValueIndex", "endIndex"})
    @Generated
    public PlaceholderBorders(StringBuilder line, int startIndex, int configTypeEndIndex, int envIndex, int keyIndex, int defaultValueIndex, int endIndex) {
        this.line = line;
        this.startIndex = startIndex;
        this.configTypeEndIndex = configTypeEndIndex;
        this.envIndex = envIndex;
        this.keyIndex = keyIndex;
        this.defaultValueIndex = defaultValueIndex;
        this.endIndex = endIndex;
    }

    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Generated
    public int getEndIndex() {
        return this.endIndex;
    }
}

