/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.resolvers.placeholder;

import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.DeclaringComponentImpl;
import io.microconfig.core.properties.PlaceholderResolveStrategy;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.ResolveException;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.resolvers.RecursiveResolver;
import io.microconfig.core.properties.resolvers.placeholder.Placeholder;
import io.microconfig.core.properties.resolvers.placeholder.PlaceholderBorders;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class PlaceholderResolver
implements RecursiveResolver {
    private final PlaceholderResolveStrategy strategy;
    private final Set<String> nonOverridableKeys;
    private final Set<Placeholder> visited;

    public PlaceholderResolver(PlaceholderResolveStrategy strategy, Set<String> nonOverridableKeys) {
        this(strategy, nonOverridableKeys, Collections.emptySet());
    }

    @Override
    public Optional<RecursiveResolver.Statement> findStatementIn(CharSequence line) {
        return PlaceholderBorders.findPlaceholderIn(line).map(x$0 -> new PlaceholderStatement((PlaceholderBorders)x$0));
    }

    @ConstructorProperties(value={"strategy", "nonOverridableKeys", "visited"})
    @Generated
    private PlaceholderResolver(PlaceholderResolveStrategy strategy, Set<String> nonOverridableKeys, Set<Placeholder> visited) {
        this.strategy = strategy;
        this.nonOverridableKeys = nonOverridableKeys;
        this.visited = visited;
    }

    @Generated
    private PlaceholderResolver withVisited(Set<Placeholder> visited) {
        return this.visited == visited ? this : new PlaceholderResolver(this.strategy, this.nonOverridableKeys, visited);
    }

    private class PlaceholderStatement
    implements RecursiveResolver.Statement {
        private final PlaceholderBorders borders;

        @Override
        public int getStartIndex() {
            return this.borders.getStartIndex();
        }

        @Override
        public int getEndIndex() {
            return this.borders.getEndIndex();
        }

        @Override
        public String resolveFor(DeclaringComponent sourceOfValue, DeclaringComponent root) {
            Placeholder placeholder = this.borders.toPlaceholder(sourceOfValue.getConfigType(), sourceOfValue.getEnvironment());
            try {
                return this.canBeOverridden(placeholder, sourceOfValue) ? this.overrideByParents(placeholder, sourceOfValue, root) : this.resolve(placeholder, root);
            }
            catch (RuntimeException e) {
                String defaultValue = placeholder.getDefaultValue();
                if (defaultValue != null) {
                    return defaultValue;
                }
                throw new ResolveException(sourceOfValue, root, "Can't resolve " + this, e);
            }
        }

        private boolean canBeOverridden(Placeholder p, DeclaringComponent sourceOfValue) {
            return p.isSelfReferenced() || p.referencedTo(sourceOfValue) && !PlaceholderResolver.this.nonOverridableKeys.contains(p.getKey());
        }

        private String overrideByParents(Placeholder p, DeclaringComponent sourceOfValue, DeclaringComponent root) {
            Function<DeclaringComponent, String> tryResolveFor = override -> {
                try {
                    return this.resolve(p.overrideBy((DeclaringComponent)override), root);
                }
                catch (RuntimeException e) {
                    return null;
                }
            };
            return Stream.of(Stream.of(root), PlaceholderResolver.this.visited.stream().map(Placeholder::getReferencedComponent), Stream.of(sourceOfValue)).flatMap(Function.identity()).map(DeclaringComponentImpl::copyOf).distinct().map(tryResolveFor).filter(Objects::nonNull).findFirst().orElseThrow(() -> new ResolveException(sourceOfValue, root, "Can't resolve placeholder " + this));
        }

        private String resolve(Placeholder p, DeclaringComponent root) {
            Property resolved = p.resolveUsing(PlaceholderResolver.this.strategy, root);
            return resolved.resolveBy((Resolver)this.currentResolverWithVisited(p), root).getValue();
        }

        private PlaceholderResolver currentResolverWithVisited(Placeholder placeholder) {
            LinkedHashSet<Placeholder> updated = new LinkedHashSet<Placeholder>(PlaceholderResolver.this.visited);
            if (updated.add(placeholder)) {
                return PlaceholderResolver.this.withVisited(Collections.unmodifiableSet(updated));
            }
            throw new IllegalStateException("Found cyclic dependencies:\n" + updated.stream().map(Placeholder::toString).collect(Collectors.joining(" -> ")));
        }

        public String toString() {
            return this.borders.toString();
        }

        @ConstructorProperties(value={"borders"})
        @Generated
        public PlaceholderStatement(PlaceholderBorders borders) {
            this.borders = borders;
        }
    }
}

