/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.resolvers.placeholder.strategies.component.properties;

import io.microconfig.core.environments.EnvironmentRepository;
import io.microconfig.core.properties.repository.ComponentGraph;
import io.microconfig.core.properties.resolvers.placeholder.strategies.component.ComponentProperty;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Optional;
import lombok.Generated;

public class ConfigDirProperty
implements ComponentProperty {
    private final ComponentGraph componentGraph;
    private final EnvironmentRepository environmentRepository;

    @Override
    public String key() {
        return "configDir";
    }

    @Override
    public Optional<String> resolveFor(String componentName, String environment) {
        Optional<String> dir = this.findDirBy(componentName);
        if (dir.isPresent()) {
            return dir;
        }
        return this.findDirBy(this.originalNameOf(componentName, environment));
    }

    private Optional<String> findDirBy(String component) {
        return this.componentGraph.getFolderOf(component).map(File::getAbsolutePath).map(StringUtils::unixLikePath);
    }

    private String originalNameOf(String component, String env) {
        return this.environmentRepository.getOrCreateByName(env).findComponentWithName(component).getOriginalName();
    }

    @ConstructorProperties(value={"componentGraph", "environmentRepository"})
    @Generated
    public ConfigDirProperty(ComponentGraph componentGraph, EnvironmentRepository environmentRepository) {
        this.componentGraph = componentGraph;
        this.environmentRepository = environmentRepository;
    }
}

