/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.resolvers.placeholder.strategies.environment;

import io.microconfig.core.environments.Environment;
import io.microconfig.core.environments.EnvironmentRepository;
import io.microconfig.core.environments.repository.EnvironmentException;
import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.DeclaringComponentImpl;
import io.microconfig.core.properties.PlaceholderResolveStrategy;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.PropertyImpl;
import io.microconfig.core.properties.resolvers.placeholder.strategies.environment.EnvProperty;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class EnvironmentResolveStrategy
implements PlaceholderResolveStrategy {
    private final EnvironmentRepository environmentRepository;
    private final Map<String, EnvProperty> propertyByKey;

    public Optional<Property> resolve(String component, String key, String env, String configType, String _1) {
        EnvProperty envProperty = this.propertyByKey.get(key);
        if (envProperty == null) {
            return Optional.empty();
        }
        Environment environment = this.getEnvironment(env);
        if (environment == null) {
            return Optional.empty();
        }
        return envProperty.resolveFor(component, environment).map(value -> PropertyImpl.property(key, value, ConfigFormat.PROPERTIES, new DeclaringComponentImpl(configType, component, env)));
    }

    private Environment getEnvironment(String environment) {
        try {
            return this.environmentRepository.getByName(environment);
        }
        catch (EnvironmentException e) {
            return null;
        }
    }

    @ConstructorProperties(value={"environmentRepository", "propertyByKey"})
    @Generated
    public EnvironmentResolveStrategy(EnvironmentRepository environmentRepository, Map<String, EnvProperty> propertyByKey) {
        this.environmentRepository = environmentRepository;
        this.propertyByKey = propertyByKey;
    }
}

