/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.resolvers.placeholder.strategies.system;

import io.microconfig.core.properties.ConfigFormat;
import io.microconfig.core.properties.DeclaringComponentImpl;
import io.microconfig.core.properties.PlaceholderResolveStrategy;
import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.PropertyImpl;
import io.microconfig.utils.Os;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;

public class SystemResolveStrategy
implements PlaceholderResolveStrategy {
    public static final String ENV_OS_SOURCE = "env";
    public static final String SYSTEM_SOURCE = "system";
    private final String type;
    private final UnaryOperator<String> resolver;

    public static PlaceholderResolveStrategy systemPropertiesResolveStrategy() {
        return new SystemResolveStrategy(SYSTEM_SOURCE, System::getProperty);
    }

    public static PlaceholderResolveStrategy envVariablesResolveStrategy() {
        return new SystemResolveStrategy(ENV_OS_SOURCE, System::getenv);
    }

    public Optional<Property> resolve(String component, String key, String environment, String configType, String _1) {
        if (!this.type.equals(component)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.resolver.apply(key)).map(v -> this.escapeOnWindows((String)v, key)).map(v -> PropertyImpl.property(key, v, ConfigFormat.PROPERTIES, new DeclaringComponentImpl(configType, component, environment)));
    }

    private String escapeOnWindows(String value, String key) {
        if (!Os.isWindows()) {
            return value;
        }
        return "user.home".equals(key) ? StringUtils.unixLikePath((String)value) : StringUtils.escape((String)value);
    }

    @ConstructorProperties(value={"type", "resolver"})
    @Generated
    public SystemResolveStrategy(String type, UnaryOperator<String> resolver) {
        this.type = type;
        this.resolver = resolver;
    }
}

