/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.serializers;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.io.selector.ConfigIoFactory;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.Logger;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ConfigDiff {
    private static final String DIFF_PREFIX = "diff-";

    public void storeDiffFor(File previousConfigFile, Collection<Property> newProperties) {
        Map<String, String> oldProperties = this.readOldConfig(previousConfigFile);
        Map<String, String> diff = this.compare(new HashMap<String, String>(oldProperties), newProperties);
        File diffFile = this.diffFileFor(previousConfigFile);
        if (diff.isEmpty()) {
            FileUtils.delete((File)diffFile);
        } else {
            Logger.warn((String)("Stored " + diff.size() + " property changes to " + diffFile.getParentFile().getName() + "/" + diffFile.getName()));
            ConfigIoFactory.configIo().writeTo(diffFile).write(diff);
        }
    }

    private File diffFileFor(File current) {
        return new File(current.getParent(), DIFF_PREFIX + current.getName());
    }

    private Map<String, String> readOldConfig(File current) {
        try {
            return ConfigIoFactory.configIo().readFrom(current).propertiesAsMap();
        }
        catch (RuntimeException e) {
            Logger.error((String)("Can't read previous config '" + current + "' for comparison: " + e.getMessage()));
            return Collections.emptyMap();
        }
    }

    private Map<String, String> compare(Map<String, String> old, Collection<Property> current) {
        if (old.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Property p : current) {
            if (p.isVar()) continue;
            String oldValue2 = old.remove(p.getKey());
            if (oldValue2 == null) {
                this.markAdded(p.getKey(), p.getValue(), result);
                continue;
            }
            if (this.linesEquals(p.getValue(), oldValue2)) continue;
            this.markChanged(p.getKey(), oldValue2, p.getValue(), result);
        }
        old.forEach((k, oldValue) -> this.markRemoved((String)k, (String)oldValue, (Map<String, String>)result));
        return result;
    }

    private boolean linesEquals(String current, String old) {
        return current.trim().equals(old.trim());
    }

    private void markAdded(String key, String value, Map<String, String> result) {
        result.put("+" + key, value);
    }

    private void markRemoved(String key, String value, Map<String, String> result) {
        result.put("-" + key, value);
    }

    private void markChanged(String key, String oldValue, String currentValue, Map<String, String> result) {
        result.put(key, oldValue + " -> " + currentValue);
    }
}

