/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates;

import io.microconfig.core.templates.Template;
import io.microconfig.utils.IoUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import lombok.Generated;

public class BinaryTemplate
implements Template {
    private final String templateName;
    private final File source;
    private final File destination;
    private final byte[] contentAsBytes;

    public BinaryTemplate(String templateName, File source, File destination) {
        this.templateName = templateName;
        this.source = source;
        this.destination = destination;
        this.contentAsBytes = IoUtils.readAllBytes((File)source);
    }

    public String getFileName() {
        return this.destination.getName();
    }

    public String getContent() {
        return new String(this.contentAsBytes);
    }

    @Generated
    public String getTemplateName() {
        return this.templateName;
    }

    @Generated
    public File getSource() {
        return this.source;
    }

    @Generated
    public File getDestination() {
        return this.destination;
    }

    @Generated
    public byte[] getContentAsBytes() {
        return this.contentAsBytes;
    }

    @ConstructorProperties(value={"templateName", "source", "destination", "contentAsBytes"})
    @Generated
    public BinaryTemplate(String templateName, File source, File destination, byte[] contentAsBytes) {
        this.templateName = templateName;
        this.source = source;
        this.destination = destination;
        this.contentAsBytes = contentAsBytes;
    }
}

