/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates;

import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.core.properties.resolvers.placeholder.PlaceholderBorders;
import io.microconfig.core.properties.templates.TemplateContentPostProcessor;
import io.microconfig.core.templates.Template;
import io.microconfig.utils.IoUtils;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class StringTemplate
implements Template {
    private final String templateName;
    private final File source;
    private final File destination;
    private final Pattern pattern;
    private final String content;

    StringTemplate(String templateName, File source, File destination, Pattern pattern) {
        this.templateName = templateName;
        this.source = source;
        this.destination = destination;
        this.pattern = pattern;
        this.content = IoUtils.readFully((File)source);
    }

    public static boolean isValidPlaceholder(String value) {
        return PlaceholderBorders.findPlaceholderIn(value).isPresent();
    }

    StringTemplate resolveBy(Resolver resolver, DeclaringComponent currentComponent) {
        String replaced = this.content.replace("${this@templateName}", this.templateNameWithoutBrackets());
        Matcher m = this.pattern.matcher(replaced);
        if (!m.find()) {
            return this.withContent(replaced);
        }
        StringBuffer result = new StringBuffer();
        do {
            this.doResolve(m, result, resolver, currentComponent);
        } while (m.find());
        m.appendTail(result);
        String content = result.toString();
        return this.withContent(content);
    }

    String templateNameWithoutBrackets() {
        return this.templateName.replaceFirst("\\[.+]$", "");
    }

    StringTemplate postProcessContent(TemplateContentPostProcessor postProcessor, String templateType, TypedProperties properties) {
        return this.withContent(postProcessor.process(templateType, this.source, this.content, properties));
    }

    private void doResolve(Matcher m, StringBuffer result, Resolver resolver, DeclaringComponent currentComponent) {
        if (m.group("escaped") != null) {
            m.appendReplacement(result, Matcher.quoteReplacement(m.group("placeholder")));
            return;
        }
        String resolved = this.resolve(m.group(), currentComponent, resolver);
        if (resolved == null) {
            return;
        }
        String finalValue = this.addOffsetForMultiLineValue(resolved, m);
        m.appendReplacement(result, Matcher.quoteReplacement(finalValue));
    }

    private String resolve(String placeholder, DeclaringComponent currentComponent, Resolver resolver) {
        if (StringTemplate.isValidPlaceholder(placeholder)) {
            return this.doResolve(placeholder, resolver, currentComponent);
        }
        String newFormat = "${this@" + placeholder.substring("${".length());
        if (!StringTemplate.isValidPlaceholder(newFormat)) {
            return null;
        }
        try {
            return this.doResolve(newFormat, resolver, currentComponent);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String doResolve(String placeholder, Resolver resolver, DeclaringComponent currentComponent) {
        return resolver.resolve(placeholder, currentComponent, currentComponent);
    }

    private String addOffsetForMultiLineValue(String value, Matcher m) {
        int lineBeginIndex = this.content.lastIndexOf(10, m.start());
        int placeholderOffset = m.start() - lineBeginIndex - 1;
        return value.replace("\n", StringUtils.addOffsets((String)"\n", (int)placeholderOffset));
    }

    public String getFileName() {
        return this.destination.getName();
    }

    public byte[] getContentAsBytes() {
        return this.content.getBytes();
    }

    @ConstructorProperties(value={"templateName", "source", "destination", "pattern", "content"})
    @Generated
    public StringTemplate(String templateName, File source, File destination, Pattern pattern, String content) {
        this.templateName = templateName;
        this.source = source;
        this.destination = destination;
        this.pattern = pattern;
        this.content = content;
    }

    @Generated
    public File getSource() {
        return this.source;
    }

    @Generated
    public File getDestination() {
        return this.destination;
    }

    @Generated
    public StringTemplate withContent(String content) {
        return this.content == content ? this : new StringTemplate(this.templateName, this.source, this.destination, this.pattern, content);
    }

    @Generated
    public String getContent() {
        return this.content;
    }
}

