/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates;

import io.microconfig.core.properties.DeclaringComponent;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.core.properties.templates.BinaryTemplate;
import io.microconfig.core.properties.templates.MustacheTemplateProcessor;
import io.microconfig.core.properties.templates.StringTemplate;
import io.microconfig.core.properties.templates.TemplateContentPostProcessor;
import io.microconfig.core.properties.templates.TemplatePattern;
import io.microconfig.core.templates.Template;
import io.microconfig.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import lombok.Generated;

public class TemplateDefinition {
    private final String templateType;
    private final String templateName;
    private final TemplatePattern templatePattern;
    private final TemplateContentPostProcessor templateContentPostProcessor;
    private File fromFile;
    private File toFile;

    public TemplateDefinition(String templateType, String templateName, TemplatePattern pattern) {
        this(templateType, templateName, pattern, new MustacheTemplateProcessor());
    }

    public Template resolve(Resolver resolver, TypedProperties properties) {
        if (this.isBinaryTemplate()) {
            return this.toBinaryTemplate(resolver, properties);
        }
        return this.toStringTemplate(resolver, properties);
    }

    private StringTemplate toStringTemplate(Resolver resolver, TypedProperties properties) {
        DeclaringComponent currentComponent = properties.getDeclaringComponent();
        try {
            File destinationFile = this.destinationFileFor(currentComponent, resolver);
            return this.toStringTemplate(destinationFile).resolveBy(resolver, currentComponent).postProcessContent(this.templateContentPostProcessor, this.templateType, properties);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Template error: " + this + "\nComponent: " + currentComponent + "\n" + StringUtils.getExceptionMessage((Throwable)e), e);
        }
    }

    private Template toBinaryTemplate(Resolver resolver, TypedProperties properties) {
        DeclaringComponent currentComponent = properties.getDeclaringComponent();
        File destinationFile = this.destinationFileFor(currentComponent, resolver);
        return new BinaryTemplate(this.templateName, this.getTemplateFile(), destinationFile);
    }

    private boolean isBinaryTemplate() {
        return this.templateType.equals("file");
    }

    private StringTemplate toStringTemplate(File destination) {
        if (!this.isCorrect()) {
            throw new IllegalStateException("Incomplete template def: " + this);
        }
        return new StringTemplate(this.templateName, this.getTemplateFile(), destination, this.templatePattern.getPlaceholderPattern());
    }

    private boolean isCorrect() {
        return this.fromFile != null && this.toFile != null;
    }

    private File getTemplateFile() {
        if (!this.fromFile.isAbsolute()) {
            throw new IllegalArgumentException("Using relative path for template '" + this.fromFile + "'. Template path must be absolute. Consider using '${this@configRoot}\\..' or '${component_name@configDir}\\..' to build absolute path");
        }
        if (!this.fromFile.exists() || !this.fromFile.isFile()) {
            throw new IllegalStateException("Missing template file: " + this.fromFile);
        }
        return this.fromFile;
    }

    private File destinationFileFor(DeclaringComponent currentComponent, Resolver resolver) {
        return this.toFile.isAbsolute() ? this.toFile : new File(this.destinationDir(currentComponent, resolver), this.toFile.getPath());
    }

    private String destinationDir(DeclaringComponent currentComponent, Resolver resolver) {
        return resolver.resolve("${this@resultDir}", currentComponent, currentComponent);
    }

    public void setFromFile(String fromFile) {
        this.fromFile = new File(fromFile);
        if (this.toFile == null) {
            this.setToFile(this.fromFile.getName());
        }
    }

    public void setToFile(String toFile) {
        this.toFile = new File(toFile.replace("${templateName}", this.templateName));
    }

    public String toString() {
        return "templateName: '" + this.templateName + "', file: '" + this.fromFile + "' -> '" + this.toFile + "'";
    }

    @ConstructorProperties(value={"templateType", "templateName", "templatePattern", "templateContentPostProcessor"})
    @Generated
    public TemplateDefinition(String templateType, String templateName, TemplatePattern templatePattern, TemplateContentPostProcessor templateContentPostProcessor) {
        this.templateType = templateType;
        this.templateName = templateName;
        this.templatePattern = templatePattern;
        this.templateContentPostProcessor = templateContentPostProcessor;
    }

    @Generated
    public String getTemplateName() {
        return this.templateName;
    }

    @Generated
    public File getFromFile() {
        return this.fromFile;
    }

    @Generated
    public File getToFile() {
        return this.toFile;
    }
}

