/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.Resolver;
import io.microconfig.core.properties.TypedProperties;
import io.microconfig.core.properties.templates.TemplateDefinition;
import io.microconfig.core.properties.templates.TemplateDefinitionParser;
import io.microconfig.core.properties.templates.TemplatePattern;
import io.microconfig.core.properties.templates.definition.parser.ArrowNotationParser;
import io.microconfig.core.properties.templates.definition.parser.FromToNotationParser;
import io.microconfig.core.properties.templates.definition.parser.SquareBracketsNotationParser;
import io.microconfig.core.templates.Template;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;

public class TemplatesService {
    private final TemplatePattern templatePattern;
    private final List<TemplateDefinitionParser> templateDefinitionParsers;

    public TemplatesService() {
        this.templatePattern = TemplatePattern.defaultPattern();
        this.templateDefinitionParsers = Arrays.asList(new FromToNotationParser(this.templatePattern), new ArrowNotationParser(this.templatePattern), new SquareBracketsNotationParser(this.templatePattern));
    }

    public static UnaryOperator<TypedProperties> resolveTemplatesBy(Resolver resolver) {
        TemplatesService templatesService = new TemplatesService();
        return tp -> tp.withTemplates(templatesService.resolveTemplates((TypedProperties)tp, resolver)).without(p -> templatesService.templatePattern.startsWithTemplatePrefix(p.getKey()));
    }

    public List<Template> resolveTemplates(TypedProperties properties, Resolver resolver) {
        return this.findTemplateDefinitionsFrom(properties.getProperties()).stream().map(def -> def.resolve(resolver, properties)).collect(Collectors.toList());
    }

    private Collection<TemplateDefinition> findTemplateDefinitionsFrom(Collection<Property> componentProperties) {
        List templateProperties = componentProperties.stream().filter(p -> this.templatePattern.startsWithTemplatePrefix(p.getKey())).collect(Collectors.toList());
        return this.templateDefinitionParsers.stream().map(parser -> parser.parse(templateProperties)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"templatePattern", "templateDefinitionParsers"})
    @Generated
    public TemplatesService(TemplatePattern templatePattern, List<TemplateDefinitionParser> templateDefinitionParsers) {
        this.templatePattern = templatePattern;
        this.templateDefinitionParsers = templateDefinitionParsers;
    }
}

